/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.RegularSectionLayout;
import ucar.nc2.iosp.hdf5.H5chunkFilterLayout;
import ucar.nc2.iosp.hdf5.H5chunkLayout;
import ucar.nc2.iosp.hdf5.H5eos;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public class H5iosp
extends AbstractIOServiceProvider {
    static boolean debug = false;
    static boolean debugPos = false;
    static boolean debugHeap = false;
    static boolean debugFilter = false;
    static boolean debugFilterDetails = false;
    static boolean debugString = false;
    static boolean debugFilterIndexer = false;
    static boolean debugChunkIndexer = false;
    static boolean debugVlen = false;
    private static Logger log = LoggerFactory.getLogger(H5iosp.class);
    private NetcdfFile ncfile;
    private RandomAccessFile myRaf;
    private H5header headerParser;
    private boolean showBytes = false;
    private boolean showHeaderBytes = false;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debug = debugFlag.isSet("H5iosp/read");
        debugPos = debugFlag.isSet("H5iosp/filePos");
        debugHeap = debugFlag.isSet("H5iosp/Heap");
        debugFilter = debugFlag.isSet("H5iosp/filter");
        debugFilterIndexer = debugFlag.isSet("H5iosp/filterIndexer");
        debugChunkIndexer = debugFlag.isSet("H5iosp/chunkIndexer");
        debugVlen = debugFlag.isSet("H5iosp/vlen");
        H5header.setDebugFlags(debugFlag);
    }

    public static void setDebugOutputStream(PrintStream printStream) {
        H5header.debugOut = printStream;
    }

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return H5header.isValidFile(raf);
    }

    public void setSpecial(Object special) {
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.ncfile = ncfile;
        this.myRaf = raf;
        this.headerParser = new H5header(this.myRaf, ncfile, this);
        this.headerParser.read();
        Group root = ncfile.getRootGroup();
        Group eos = root.findGroup("HDFEOS_INFORMATION");
        if (null != eos) {
            H5eos.parse(ncfile);
        }
        ncfile.finish();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        return this.readData(v2, vinfo.dataPos, section);
    }

    private Array readData(Variable v2, long dataPos, Section wantSection) throws IOException, InvalidRangeException {
        Object data;
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (vinfo.useFillValue) {
            Object pa = this.fillArray((int)wantSection.computeSize(), dataType, vinfo.getFillValue());
            if (dataType == DataType.CHAR) {
                pa = this.convertByteToChar((byte[])pa);
            }
            return Array.factory(dataType.getPrimitiveClassType(), wantSection.getShape(), pa);
        }
        if (vinfo.mfp != null) {
            if (debugFilter) {
                H5header.debugOut.println("read variable filtered " + v2.getName() + " vinfo = " + vinfo);
            }
            assert (vinfo.isChunked);
            H5chunkFilterLayout index = new H5chunkFilterLayout(v2, wantSection, this.myRaf, vinfo.mfp.getFilters());
            data = this.readFilteredData(v2, index, vinfo.getFillValue());
        } else {
            if (debug) {
                H5header.debugOut.println("read variable " + v2.getName() + " vinfo = " + vinfo);
            }
            DataType readDtype = v2.getDataType();
            int elemSize = v2.getElementSize();
            Object fillValue = vinfo.getFillValue();
            int byteOrder = vinfo.typeInfo.byteOrder;
            if (vinfo.typeInfo.hdfType == 2) {
                readDtype = vinfo.mdt.timeType;
                elemSize = readDtype.getSize();
                fillValue = vinfo.getFillValueDefault(readDtype);
            } else if (vinfo.typeInfo.hdfType == 8) {
                H5header.TypeInfo baseInfo = vinfo.typeInfo.base;
                readDtype = baseInfo.dataType;
                elemSize = readDtype.getSize();
                fillValue = vinfo.getFillValueDefault(readDtype);
                byteOrder = baseInfo.byteOrder;
            } else if (vinfo.typeInfo.hdfType == 9) {
                elemSize = vinfo.typeInfo.byteSize;
                byteOrder = vinfo.typeInfo.byteOrder;
            }
            Indexer index = vinfo.isChunked ? new H5chunkLayout(v2, readDtype, wantSection) : RegularSectionLayout.factory(dataPos, elemSize, new Section(v2.getShape()), wantSection);
            data = this.readData(vinfo.typeInfo, v2, index, readDtype, wantSection.getShape(), fillValue, byteOrder);
        }
        if (data instanceof Array) {
            return (Array)data;
        }
        return Array.factory(dataType.getPrimitiveClassType(), wantSection.getShape(), data);
    }

    private Object readData(H5header.TypeInfo typeInfo, Variable v, Indexer index, DataType dataType, int[] shape, Object fillValue, int byteOrder) throws IOException, InvalidRangeException {
        if (typeInfo.hdfType == 2) {
            Object data = this.readDataPrimitive(index, dataType, fillValue, byteOrder);
            Array timeArray = Array.factory(dataType.getPrimitiveClassType(), shape, data);
            String[] stringData = new String[(int)timeArray.getSize()];
            int count = 0;
            IndexIterator ii = timeArray.getIndexIterator();
            while (ii.hasNext()) {
                long time = ii.getLongNext();
                stringData[count++] = this.headerParser.formatter.toDateTimeStringISO(new Date(time));
            }
            return Array.factory(String.class, shape, (Object)stringData);
        }
        if (typeInfo.hdfType == 8) {
            Object data = this.readDataPrimitive(index, dataType, fillValue, byteOrder);
            Array codesArray = Array.factory(dataType.getPrimitiveClassType(), shape, data);
            String[] stringData = new String[(int)codesArray.getSize()];
            int count = 0;
            IndexIterator ii = codesArray.getIndexIterator();
            while (ii.hasNext()) {
                int code = ii.getIntNext();
                stringData[count++] = "N?A";
            }
            return Array.factory(String.class, shape, (Object)stringData);
        }
        if (typeInfo.hdfType == 9 && !typeInfo.isVString) {
            DataType readType = dataType;
            if (typeInfo.isVString) {
                readType = DataType.BYTE;
            } else if (typeInfo.base.hdfType == 7) {
                readType = DataType.LONG;
            }
            boolean scalar = index.getTotalNelems() == 1L;
            Array[] data = new Array[(int)index.getTotalNelems()];
            int count = 0;
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getFilePos() + (long)(index.getElemSize() * i);
                    Array vlenArray = this.headerParser.getHeapDataArray(address, readType, byteOrder);
                    data[count++] = typeInfo.base.hdfType == 7 ? this.convertReference(vlenArray) : vlenArray;
                }
            }
            return scalar ? data[0] : Array.factory(Array.class, shape, (Object)data);
        }
        if (dataType == DataType.STRUCTURE) {
            Structure s = (Structure)v;
            ArrayStructureW asw = new ArrayStructureW(s.makeStructureMembers(), shape);
            int count = 0;
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    if (debug) {
                        H5header.debugOut.println(" readStructure " + v.getName() + " chunk.getFilePos= " + chunk.getFilePos() + " index.getElemSize= " + index.getElemSize());
                    }
                    StructureData sdata = this.readStructure(s, asw, chunk.getFilePos() + (long)(index.getElemSize() * i));
                    asw.setStructureData(sdata, count++);
                }
            }
            return asw;
        }
        return this.readDataPrimitive(index, dataType, fillValue, byteOrder);
    }

    private Array convertReference(Array refArray) throws IOException, InvalidRangeException {
        int nelems = (int)refArray.getSize();
        Index ima = refArray.getIndex();
        String[] result = new String[nelems];
        for (int i = 0; i < nelems; ++i) {
            long reference = refArray.getLong(ima.set(i));
            result[i] = this.headerParser.getDataObjectName(reference);
        }
        return Array.factory(String.class, new int[]{nelems}, (Object)result);
    }

    private Object readDataPrimitive(Indexer index, DataType dataType, Object fillValue, int byteOrder) throws IOException, InvalidRangeException {
        int size = (int)index.getTotalNelems();
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.OPAQUE) {
            byte[] pa = (byte[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                this.myRaf.seek(chunk.getFilePos());
                this.myRaf.read(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return dataType == DataType.CHAR ? (Object[])this.convertByteToChar(pa) : pa;
        }
        if (dataType == DataType.SHORT) {
            short[] pa = (short[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                if (byteOrder >= 0) {
                    this.myRaf.order(byteOrder);
                }
                this.myRaf.seek(chunk.getFilePos());
                this.myRaf.readShort(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.INT) {
            int[] pa = (int[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                if (byteOrder >= 0) {
                    this.myRaf.order(byteOrder);
                }
                this.myRaf.seek(chunk.getFilePos());
                this.myRaf.readInt(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = (long[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                if (byteOrder >= 0) {
                    this.myRaf.order(byteOrder);
                }
                this.myRaf.seek(chunk.getFilePos());
                this.myRaf.readLong(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                if (byteOrder >= 0) {
                    this.myRaf.order(byteOrder);
                }
                this.myRaf.seek(chunk.getFilePos());
                this.myRaf.readFloat(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                if (byteOrder >= 0) {
                    this.myRaf.order(byteOrder);
                }
                this.myRaf.seek(chunk.getFilePos());
                this.myRaf.readDouble(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.STRING) {
            String[] sa = new String[size];
            int count = 0;
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    sa[count++] = this.headerParser.readHeapString(chunk.getFilePos() + (long)(index.getElemSize() * i));
                }
            }
            return sa;
        }
        throw new IllegalStateException("H5iosp.readDataPrimitive: Unknown DataType " + dataType);
    }

    protected Object fillArray(int size, DataType dataType, Object fillValue) throws IOException, InvalidRangeException {
        if (dataType == DataType.BYTE || dataType == DataType.CHAR) {
            byte[] pa = new byte[size];
            byte val = (Byte)fillValue;
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.OPAQUE) {
            return new byte[size];
        }
        if (dataType == DataType.SHORT) {
            short[] pa = new short[size];
            short val = (Short)fillValue;
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.INT) {
            int[] pa = new int[size];
            int val = (Integer)fillValue;
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = new long[size];
            long val = (Long)fillValue;
            if (val != 0L) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = new float[size];
            float val = ((Float)fillValue).floatValue();
            if ((double)val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = new double[size];
            double val = (Double)fillValue;
            if (val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.STRING || dataType == DataType.ENUM) {
            String[] pa = new String[size];
            for (int i = 0; i < size; ++i) {
                pa[i] = (String)fillValue;
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    private Object readFilteredData(Variable v, H5chunkFilterLayout index, Object fillValue) throws IOException, InvalidRangeException {
        DataType dataType = v.getDataType();
        int size = (int)index.getTotalNelems();
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.OPAQUE) {
            byte[] pa = (byte[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                ByteBuffer bb = index.getByteBuffer();
                bb.position((int)chunk.getFilePos());
                int pos = (int)chunk.getStartElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = bb.get();
                }
            }
            return dataType == DataType.CHAR ? (Object[])this.convertByteToChar(pa) : pa;
        }
        if (dataType == DataType.SHORT) {
            short[] pa = (short[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                ShortBuffer buff = index.getShortBuffer();
                buff.position((int)chunk.getFilePos() / 2);
                int pos = (int)chunk.getStartElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.INT) {
            int[] pa = (int[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                IntBuffer buff = index.getIntBuffer();
                buff.position((int)chunk.getFilePos() / 4);
                int pos = (int)chunk.getStartElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = (long[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                LongBuffer buff = index.getLongBuffer();
                buff.position((int)chunk.getFilePos() / 8);
                int pos = (int)chunk.getStartElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                FloatBuffer buff = index.getFloatBuffer();
                buff.position((int)chunk.getFilePos() / 4);
                int pos = (int)chunk.getStartElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])this.fillArray(size, dataType, fillValue);
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                if (chunk == null) continue;
                DoubleBuffer buff = index.getDoubleBuffer();
                buff.position((int)chunk.getFilePos() / 8);
                int pos = (int)chunk.getStartElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    private StructureData readStructure(Structure s, ArrayStructureW asw, long dataPos) throws IOException, InvalidRangeException {
        StructureDataW sdata = new StructureDataW(asw.getStructureMembers());
        if (debug) {
            H5header.debugOut.println(" readStructure " + s.getName() + " dataPos = " + dataPos);
        }
        for (Variable v2 : s.getVariables()) {
            H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
            if (debug) {
                H5header.debugOut.println(" readStructureMember " + v2.getName() + " vinfo = " + vinfo);
            }
            Array dataArray = this.readData(v2, dataPos + vinfo.dataPos, v2.getShapeAsSection());
            sdata.setMemberData(v2.getShortName(), dataArray);
        }
        return sdata;
    }

    protected char[] convertByteToChar(byte[] byteArray) {
        int size = byteArray.length;
        char[] cbuff = new char[size];
        for (int i = 0; i < size; ++i) {
            cbuff[i] = (char)DataType.unsignedByteToShort(byteArray[i]);
        }
        return cbuff;
    }

    protected byte[] convertCharToByte(char[] from) {
        int size = from.length;
        byte[] to = new byte[size];
        for (int i = 0; i < size; ++i) {
            to[i] = (byte)from[i];
        }
        return to;
    }

    public boolean syncExtend() {
        return false;
    }

    public boolean sync() {
        return false;
    }

    public void flush() throws IOException {
        this.myRaf.flush();
    }

    public void close() throws IOException {
        if (this.myRaf != null) {
            this.myRaf.close();
        }
        this.headerParser.close();
    }

    public String toStringDebug(Object o) {
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            H5header.Vinfo vinfo = (H5header.Vinfo)v.getSPobject();
            return vinfo.toString();
        }
        return null;
    }

    public String getDetailInfo() {
        return "";
    }
}

