/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.common.RandomAccessStream;

public class Updater
implements PlugIn {
    protected static final String TRUNK_BUILD = "http://hudson.openmicroscopy.org.uk/job/LOCI/lastSuccessfulBuild/artifact/trunk/artifacts/loci_tools.jar";
    protected static final String TODAYS_BUILD = "http://loci.wisc.edu/software/daily/loci_tools.jar";
    protected static final String YESTERDAYS_BUILD = "http://loci.wisc.edu/software/daily.old/loci_tools.jar";
    protected static final String STABLE_BUILD = "http://loci.wisc.edu/software/loci_tools.jar";
    protected static final String STABLE_VERSION = "29 December 2008";
    public boolean canceled;
    private String arg;

    public void run(String arg) {
        GenericDialog upgradeDialog = new GenericDialog("Update LOCI Plugins");
        String[] options = new String[]{"Trunk build", "Daily build (today)", "Daily build (yesterday)", "Stable build (29 December 2008)"};
        upgradeDialog.addChoice("Release", options, options[0]);
        upgradeDialog.showDialog();
        if (upgradeDialog.wasCanceled()) {
            this.canceled = true;
            return;
        }
        String release = upgradeDialog.getNextChoice();
        if (release.equals(options[0])) {
            Updater.install(TRUNK_BUILD);
        } else if (release.equals(options[1])) {
            Updater.install(TODAYS_BUILD);
        } else if (release.equals(options[2])) {
            Updater.install(YESTERDAYS_BUILD);
        } else {
            Updater.install(STABLE_BUILD);
        }
    }

    protected static void install(String url) {
        String pluginsDirectory = IJ.getDirectory((String)"plugins");
        String jarPath = pluginsDirectory + File.separator + "loci_tools.jar";
        String downloadPath = jarPath + ".tmp";
        File plugin = new File(downloadPath);
        if (plugin.exists()) {
            plugin.delete();
        }
        IJ.showStatus((String)"Downloading loci_tools.jar...");
        try {
            RandomAccessStream in = new RandomAccessStream(url);
            byte[] buf = new byte[(int)in.length()];
            in.read(buf);
            in.close();
            FileOutputStream out = new FileOutputStream(plugin);
            out.write(buf);
            out.close();
            plugin.renameTo(new File(jarPath));
        }
        catch (IOException e) {
            IJ.showMessage((String)"An error occurred while downloading the LOCI plugins");
            e.printStackTrace();
            return;
        }
        IJ.showStatus((String)"");
        IJ.showMessage((String)"The LOCI plugins have been downloaded.\nPlease restart ImageJ to complete the upgrade process.");
    }
}

