/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;

public class OMETiffReader
extends FormatReader {
    protected OMETiffPlane[][] info;
    protected String[] used;

    public OMETiffReader() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return TiffTools.isValidHeader(stream);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int width, int height) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        IFormatReader r = this.info[this.series][no].reader;
        r.setId(this.info[this.series][no].id);
        return r.openBytes(this.info[this.series][no].ifd, buf, x, y, width, height);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.used;
    }

    public int fileGroupOption(String id) {
        return 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (debug) {
            this.debug("OMETiffReader.initFile(" + id + ")");
        }
        super.initFile(this.normalizeFilename(null, id));
        id = this.currentId;
        String dir = new File(id).getParent();
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        RandomAccessStream ras = new RandomAccessStream(fileName);
        Hashtable firstIFD = TiffTools.getFirstIFD(ras);
        ras.close();
        String xml = TiffTools.getComment(firstIFD);
        IMetadata meta = MetadataTools.createOMEXMLMetadata(xml);
        if (meta == null) {
            throw new FormatException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://loci.wisc.edu/ome/formats-library.html");
        }
        String currentUUID = meta.getUUID();
        MetadataTools.convertMetadata(meta, this.metadataStore);
        int seriesCount = 0;
        int imageCount = meta.getImageCount();
        for (i = 0; i < imageCount; ++i) {
            seriesCount += meta.getPixelsCount(i);
        }
        this.core = new CoreMetadata[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.info = new OMETiffPlane[seriesCount][];
        Hashtable<String, String> files = new Hashtable<String, String>();
        boolean needSearch = false;
        for (int i2 = 0; i2 < imageCount; ++i2) {
            int pixelsCount = meta.getPixelsCount(i2);
            for (int p = 0; p < pixelsCount; ++p) {
                int tiffDataCount = meta.getTiffDataCount(i2, p);
                for (int td = 0; td < tiffDataCount; ++td) {
                    String uuid = meta.getTiffDataUUID(i2, p, td);
                    String filename = null;
                    if (uuid == null) {
                        uuid = "";
                        filename = id;
                    } else {
                        filename = meta.getTiffDataFileName(i2, p, td);
                        if (filename == null) {
                            if (uuid.equals(currentUUID)) {
                                filename = id;
                            } else {
                                filename = "";
                                needSearch = true;
                            }
                        } else {
                            filename = this.normalizeFilename(dir, filename);
                        }
                    }
                    String existing = (String)files.get(uuid);
                    if (existing == null) {
                        files.put(uuid, filename);
                        continue;
                    }
                    if (existing.equals(filename)) continue;
                    throw new FormatException("Inconsistent UUID filenames");
                }
            }
        }
        if (needSearch) {
            Enumeration en = files.keys();
            while (en.hasMoreElements()) {
                String uuid = (String)en.nextElement();
                String filename = (String)files.get(uuid);
                if (!filename.equals("")) continue;
                throw new FormatException("Unmatched UUID: " + uuid);
            }
        }
        Enumeration en = files.keys();
        int numUUIDs = files.size();
        HashSet<String> fileSet = new HashSet<String>();
        for (int i3 = 0; i3 < numUUIDs; ++i3) {
            String uuid = (String)en.nextElement();
            String filename = (String)files.get(uuid);
            fileSet.add(filename);
        }
        this.used = new String[fileSet.size()];
        Iterator iter = fileSet.iterator();
        for (int i4 = 0; i4 < this.used.length; ++i4) {
            this.used[i4] = (String)iter.next();
        }
        Hashtable<String, IFormatReader> readers = new Hashtable<String, IFormatReader>();
        int s = 0;
        for (int i5 = 0; i5 < imageCount; ++i5) {
            if (debug) {
                this.debug("Image[" + i5 + "] {");
                this.debug("  id = " + meta.getImageID(i5));
            }
            int pixelsCount = meta.getPixelsCount(i5);
            int p = 0;
            while (p < pixelsCount) {
                if (debug) {
                    this.debug("  Pixels[" + p + "] {");
                    this.debug("    id = " + meta.getPixelsID(i5, p));
                }
                String order = meta.getPixelsDimensionOrder(i5, p);
                Integer samplesPerPixel = meta.getLogicalChannelSamplesPerPixel(i5, 0);
                int samples = samplesPerPixel == null ? TiffTools.getSamplesPerPixel(firstIFD) : samplesPerPixel;
                int effSizeC = meta.getPixelsSizeC(i5, p) / samples;
                if (effSizeC == 0) {
                    effSizeC = 1;
                }
                int sizeT = meta.getPixelsSizeT(i5, p);
                int sizeZ = meta.getPixelsSizeZ(i5, p);
                int num = effSizeC * sizeT * sizeZ;
                OMETiffPlane[] planes = new OMETiffPlane[num];
                for (int no = 0; no < num; ++no) {
                    planes[no] = new OMETiffPlane();
                }
                int tiffDataCount = meta.getTiffDataCount(i5, p);
                for (int td = 0; td < tiffDataCount; ++td) {
                    int no;
                    int count;
                    if (debug) {
                        this.debug("    TiffData[" + td + "] {");
                    }
                    String filename = meta.getTiffDataFileName(i5, p, td);
                    String uuid = meta.getTiffDataUUID(i5, p, td);
                    Integer tdIFD = meta.getTiffDataIFD(i5, p, td);
                    int ifd = tdIFD == null ? 0 : tdIFD;
                    Integer numPlanes = meta.getTiffDataNumPlanes(i5, p, td);
                    Integer firstC = meta.getTiffDataFirstC(i5, p, td);
                    Integer firstT = meta.getTiffDataFirstT(i5, p, td);
                    Integer firstZ = meta.getTiffDataFirstZ(i5, p, td);
                    int c = firstC == null ? 0 : firstC;
                    int t = firstT == null ? 0 : firstT;
                    int z = firstZ == null ? 0 : firstZ;
                    int index = FormatTools.getIndex(order, sizeZ, effSizeC, sizeT, num, z, c, t);
                    int n = count = numPlanes == null ? 1 : numPlanes;
                    filename = filename == null ? (uuid == null ? id : (String)files.get(uuid)) : this.normalizeFilename(dir, filename);
                    IFormatReader r = (IFormatReader)readers.get(filename);
                    if (r == null) {
                        r = new TiffReader();
                        readers.put(filename, r);
                    }
                    for (int q = 0; q < count; ++q) {
                        int no2 = index + q;
                        planes[no2].reader = r;
                        planes[no2].id = filename;
                        planes[no2].ifd = ifd + q;
                        planes[no2].certain = true;
                        if (!debug) continue;
                        this.debug("      Plane[" + no2 + "]: file=" + planes[no2].id + ", IFD=" + planes[no2].ifd);
                    }
                    if (numPlanes == null) {
                        for (no = index + 1; no < num && !planes[no].certain; ++no) {
                            planes[no].reader = r;
                            planes[no].id = filename;
                            planes[no].ifd = planes[no - 1].ifd + 1;
                            if (!debug) continue;
                            this.debug("      Plane[" + no + "]: FILLED");
                        }
                    } else {
                        for (no = index + count; no < num && !planes[no].certain; ++no) {
                            planes[no].reader = null;
                            planes[no].id = null;
                            planes[no].ifd = -1;
                            if (!debug) continue;
                            this.debug("      Plane[" + no + "]: CLEARED");
                        }
                    }
                    if (!debug) continue;
                    this.debug("    }");
                }
                if (debug) {
                    this.debug("    --------------------------------");
                }
                for (int no = 0; no < num; ++no) {
                    if (debug) {
                        this.debug("    Plane[" + no + "]: file=" + planes[no].id + ", IFD=" + planes[no].ifd);
                    }
                    if (planes[no].reader != null) continue;
                    throw new FormatException("Pixels ID '" + meta.getPixelsID(i5, p) + "': missing plane #" + no);
                }
                if (debug) {
                    this.debug("  }");
                }
                this.info[s] = planes;
                try {
                    this.core[s].sizeX = meta.getPixelsSizeX(i5, p);
                    this.core[s].sizeY = meta.getPixelsSizeY(i5, p);
                    this.core[s].sizeZ = meta.getPixelsSizeZ(i5, p);
                    this.core[s].sizeC = meta.getPixelsSizeC(i5, p);
                    this.core[s].sizeT = meta.getPixelsSizeT(i5, p);
                    this.core[s].pixelType = FormatTools.pixelTypeFromString(meta.getPixelsPixelType(i5, p));
                    this.core[s].imageCount = num;
                    this.core[s].dimensionOrder = meta.getPixelsDimensionOrder(i5, p);
                    this.core[s].orderCertain = true;
                    int photo = TiffTools.getPhotometricInterpretation(firstIFD);
                    this.core[s].rgb = samples > 1 || photo == 2;
                    this.core[s].littleEndian = meta.getPixelsBigEndian(i5, p) == false;
                    this.core[s].interleaved = false;
                    boolean bl = this.core[s].indexed = photo == 3 && TiffTools.getIFDValue(firstIFD, 320) != null;
                    if (this.core[s].indexed) {
                        this.core[0].sizeC = 1;
                        this.core[0].rgb = false;
                    }
                    this.core[s].falseColor = false;
                    this.core[s].metadataComplete = true;
                }
                catch (NullPointerException exc) {
                    throw new FormatException("Incomplete Pixels metadata", exc);
                }
                ++p;
                ++s;
            }
            if (!debug) continue;
            this.debug("}");
        }
    }

    private IFormatReader getReader(int no) throws FormatException, IOException {
        FormatTools.checkPlaneNumber(this, no);
        IFormatReader r = this.info[this.series][no].reader;
        r.setId(this.info[this.series][no].id);
        return r;
    }

    private String normalizeFilename(String dir, String name) {
        File file2 = new File(dir, name);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return new Location(name).getAbsolutePath();
    }

    private class OMETiffPlane {
        public IFormatReader reader;
        public String id;
        public int ifd = -1;
        public boolean certain = false;

        private OMETiffPlane() {
        }
    }
}

