/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.TiffTools;

public class MinimalTiffReader
extends FormatReader {
    protected Hashtable[] ifds;

    public MinimalTiffReader() {
        super("Minimal TIFF", new String[]{"tif", "tiff"});
    }

    public MinimalTiffReader(String name, String suffix) {
        super(name, suffix);
    }

    public MinimalTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return TiffTools.isValidHeader(stream);
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int[] bits = TiffTools.getBitsPerSample(this.ifds[0]);
        if (bits[0] <= 8) {
            int[] colorMap = TiffTools.getIFDIntArray(this.ifds[0], 320, false);
            if (colorMap == null) {
                return null;
            }
            byte[][] table = new byte[3][colorMap.length / 3];
            int next = 0;
            for (int j = 0; j < table.length; ++j) {
                for (int i = 0; i < table[0].length; ++i) {
                    table[j][i] = (byte)(colorMap[next++] >> 8 & 0xFF);
                }
            }
            return table;
        }
        return null;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int[] bits = TiffTools.getBitsPerSample(this.ifds[0]);
        if (bits[0] <= 16 && bits[0] > 8) {
            int[] colorMap = TiffTools.getIFDIntArray(this.ifds[0], 320, false);
            if (colorMap == null || colorMap.length < 196608) {
                return null;
            }
            short[][] table = new short[3][colorMap.length / 3];
            int next = 0;
            for (int i = 0; i < table.length; ++i) {
                for (int j = 0; j < table[0].length; ++j) {
                    if (this.isLittleEndian()) {
                        table[i][j] = (short)(colorMap[next++] & 0xFFFF);
                        continue;
                    }
                    int n = colorMap[next++];
                    table[i][j] = (short)((n & 0xFF0000) >> 8 | (n & 0xFF000000) >> 24);
                }
            }
            return table;
        }
        return null;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int width, int height) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, width, height);
        TiffTools.getSamples(this.ifds[no], this.in, buf, x, y, width, height);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.ifds = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("MinimalTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        boolean little = this.in.readShort() == 18761;
        this.in.order(little);
        this.status("Reading IFDs");
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds == null) {
            throw new FormatException("No IFDs found");
        }
        this.status("Populating metadata");
        this.core[0].imageCount = this.ifds.length;
        int photo = TiffTools.getPhotometricInterpretation(this.ifds[0]);
        int samples = TiffTools.getSamplesPerPixel(this.ifds[0]);
        this.core[0].rgb = samples > 1 || photo == 2;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = TiffTools.isLittleEndian(this.ifds[0]);
        this.core[0].sizeX = (int)TiffTools.getImageWidth(this.ifds[0]);
        this.core[0].sizeY = (int)TiffTools.getImageLength(this.ifds[0]);
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? samples : 1;
        this.core[0].sizeT = this.ifds.length;
        this.core[0].pixelType = this.getPixelType(this.ifds[0]);
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = photo == 3 && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        if (this.getSizeC() == 1 && !this.isIndexed()) {
            this.core[0].rgb = false;
        }
        this.core[0].falseColor = false;
        this.core[0].dimensionOrder = "XYCZT";
    }

    protected int getPixelType(Hashtable ifd) throws FormatException {
        int bps = TiffTools.getBitsPerSample(ifd)[0];
        int bitFormat = TiffTools.getIFDIntValue(ifd, 339);
        while (bps % 8 != 0) {
            ++bps;
        }
        if (bps == 24) {
            bps = 32;
        }
        if (bitFormat == 3) {
            return 6;
        }
        if (bitFormat == 2) {
            switch (bps) {
                case 16: {
                    return 2;
                }
                case 32: {
                    return 4;
                }
            }
            return 0;
        }
        switch (bps) {
            case 16: {
                return 3;
            }
            case 32: {
                return 5;
            }
        }
        return 1;
    }
}

