/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;

public class DeltavisionReader
extends FormatReader {
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private static final String[] IMAGE_TYPES = new String[]{"normal", "Tilt-series", "Stereo tilt-series", "Averaged images", "Averaged stereo pairs"};
    private int extSize;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;
    private Float[] ndFilters;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d"});
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int bytesPerPixel = FormatTools.getBytesPerPixel(this.getPixelType());
        long offset = 1024 + this.extSize;
        long planeOffset = (long)this.getSizeX() * (long)this.getSizeY() * (long)bytesPerPixel * (long)no;
        this.in.seek(offset + planeOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.tSize = 0;
        this.zSize = 0;
        this.wSize = 0;
        this.extSize = 0;
        this.numFloatsPerSection = 0;
        this.numIntsPerSection = 0;
        this.extHdrFields = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String pixel;
        String imageSequence;
        if (debug) {
            this.debug("DeltavisionReader.initFile(" + id + ")");
        }
        super.initFile(id);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        this.status("Reading header");
        this.in = new RandomAccessStream(id);
        this.in.seek(96L);
        this.in.order(true);
        boolean little = this.in.readShort() == -16224;
        this.in.order(little);
        this.in.seek(0L);
        int sizeX = this.in.readInt();
        int sizeY = this.in.readInt();
        int imageCount = this.in.readInt();
        int filePixelType = this.in.readInt();
        int subImageStartX = this.in.readInt();
        int subImageStartY = this.in.readInt();
        int subImageStartZ = this.in.readInt();
        int pixelSamplingX = this.in.readInt();
        int pixelSamplingY = this.in.readInt();
        int pixelSamplingZ = this.in.readInt();
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        float xAxisAngle = this.in.readFloat();
        float yAxisAngle = this.in.readFloat();
        float zAxisAngle = this.in.readFloat();
        int xAxisSeq = this.in.readInt();
        int yAxisSeq = this.in.readInt();
        int zAxisSeq = this.in.readInt();
        this.in.seek(160L);
        short type = this.in.readShort();
        short lensID = this.in.readShort();
        this.in.seek(180L);
        short rawSizeT = this.in.readShort();
        short sizeT = rawSizeT == 0 ? (short)1 : rawSizeT;
        short sequence = this.in.readShort();
        float xTiltAngle = this.in.readFloat();
        float yTiltAngle = this.in.readFloat();
        float zTiltAngle = this.in.readFloat();
        int rawSizeC = this.in.readShort();
        int sizeC = rawSizeC == 0 ? 1 : rawSizeC;
        short[] waves = new short[5];
        for (int i2 = 0; i2 < waves.length; ++i2) {
            waves[i2] = this.in.readShort();
        }
        float xOrigin = this.in.readFloat();
        float yOrigin = this.in.readFloat();
        float zOrigin = this.in.readFloat();
        this.in.skipBytes(4);
        String[] title = new String[10];
        for (int i3 = 0; i3 < title.length; ++i3) {
            title[i3] = this.in.readString(80).replaceAll("\u0000", "");
        }
        long fp = this.in.getFilePointer();
        this.in.seek(76L);
        float[] minWave = new float[5];
        float[] maxWave = new float[5];
        minWave[0] = this.in.readFloat();
        maxWave[0] = this.in.readFloat();
        float meanIntensity = this.in.readFloat();
        int spaceGroupNumber = this.in.readInt();
        this.extSize = this.in.readInt();
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        short numSubResSets = this.in.readShort();
        short zAxisReductionQuotient = this.in.readShort();
        for (int i4 = 1; i4 <= 3; ++i4) {
            minWave[i4] = this.in.readFloat();
            maxWave[i4] = this.in.readFloat();
        }
        this.in.seek(172L);
        minWave[4] = this.in.readFloat();
        maxWave[4] = this.in.readFloat();
        String imageType = type < IMAGE_TYPES.length ? IMAGE_TYPES[type] : "unknown";
        switch (sequence) {
            case 0: {
                imageSequence = "ZTW";
                break;
            }
            case 1: {
                imageSequence = "WZT";
                break;
            }
            case 2: {
                imageSequence = "ZWT";
                break;
            }
            case 65536: {
                imageSequence = "WZT";
                break;
            }
            default: {
                imageSequence = "ZTW";
            }
        }
        int sizeZ = imageCount / (sizeC * sizeT);
        String imageDesc = title[0];
        if (imageDesc != null && imageDesc.length() == 0) {
            imageDesc = null;
        }
        this.status("Populating core metadata");
        this.core[0].littleEndian = little;
        this.core[0].sizeX = sizeX;
        this.core[0].sizeY = sizeY;
        this.core[0].imageCount = imageCount;
        switch (filePixelType) {
            case 0: {
                pixel = "8 bit unsigned integer";
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                pixel = "16 bit signed integer";
                this.core[0].pixelType = 2;
                break;
            }
            case 2: {
                pixel = "32 bit floating point";
                this.core[0].pixelType = 6;
                break;
            }
            case 3: {
                pixel = "16 bit complex";
                this.core[0].pixelType = 2;
                break;
            }
            case 4: {
                pixel = "64 bit complex";
                this.core[0].pixelType = 6;
                break;
            }
            case 6: {
                pixel = "16 bit unsigned integer";
                this.core[0].pixelType = 3;
                break;
            }
            default: {
                pixel = "unknown";
                this.core[0].pixelType = 1;
            }
        }
        this.core[0].sizeT = sizeT;
        this.core[0].dimensionOrder = "XY" + imageSequence.replaceAll("W", "C");
        this.core[0].sizeC = sizeC;
        this.core[0].sizeZ = sizeZ;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.status("Populating original metadata");
        this.addMeta("ImageWidth", sizeX);
        this.addMeta("ImageHeight", sizeY);
        this.addMeta("NumberOfImages", imageCount);
        this.addMeta("PixelType", pixel);
        this.addMeta("Sub-image starting point (X)", subImageStartX);
        this.addMeta("Sub-image starting point (Y)", subImageStartY);
        this.addMeta("Sub-image starting point (Z)", subImageStartZ);
        this.addMeta("Pixel sampling size (X)", pixelSamplingX);
        this.addMeta("Pixel sampling size (Y)", pixelSamplingY);
        this.addMeta("Pixel sampling size (Z)", pixelSamplingZ);
        this.addMeta("X element length (in um)", pixX);
        this.addMeta("Y element length (in um)", pixY);
        this.addMeta("Z element length (in um)", pixZ);
        this.addMeta("X axis angle", xAxisAngle);
        this.addMeta("Y axis angle", yAxisAngle);
        this.addMeta("Z axis angle", zAxisAngle);
        this.addMeta("Column axis sequence", xAxisSeq);
        this.addMeta("Row axis sequence", yAxisSeq);
        this.addMeta("Section axis sequence", zAxisSeq);
        this.addMeta("Image Type", imageType);
        this.addMeta("Lens ID Number", (int)lensID);
        this.addMeta("Number of timepoints", (int)rawSizeT);
        this.addMeta("Image sequence", imageSequence);
        this.addMeta("X axis tilt angle", xTiltAngle);
        this.addMeta("Y axis tilt angle", yTiltAngle);
        this.addMeta("Z axis tilt angle", zTiltAngle);
        this.addMeta("Number of wavelengths", rawSizeC);
        this.addMeta("Number of focal planes", sizeZ);
        for (i = 0; i < waves.length; ++i) {
            this.addMeta("Wavelength " + (i + 1) + " (in nm)", waves[i]);
        }
        this.addMeta("X origin (in um)", xOrigin);
        this.addMeta("Y origin (in um)", yOrigin);
        this.addMeta("Z origin (in um)", zOrigin);
        for (i = 0; i < title.length; ++i) {
            this.addMeta("Title " + (i + 1), title[i]);
        }
        for (i = 0; i < minWave.length; ++i) {
            this.addMeta("Wavelength " + (i + 1) + " min. intensity", minWave[i]);
            this.addMeta("Wavelength " + (i + 1) + " max. intensity", maxWave[i]);
        }
        this.addMeta("Wavelength 1 mean intensity", meanIntensity);
        this.addMeta("Space group number", spaceGroupNumber);
        this.addMeta("Number of Sub-resolution sets", numSubResSets);
        this.addMeta("Z axis reduction quotient", zAxisReductionQuotient);
        this.status("Populating OME metadata");
        MetadataTools.populatePixels(store, this, true);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        String objectiveID = "Objective:" + lensID;
        store.setObjectiveID(objectiveID, 0, 0);
        store.setObjectiveSettingsObjective(objectiveID, 0);
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        if (store instanceof IMinMaxStore) {
            IMinMaxStore minMaxStore = (IMinMaxStore)((Object)store);
            for (int i5 = 0; i5 < minWave.length; ++i5) {
                minMaxStore.setChannelGlobalMinMax(0, minWave[i5], maxWave[i5], i5);
            }
        }
        store.setDimensionsPhysicalSizeX(new Float(pixX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(pixY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(pixZ), 0, 0);
        store.setImageName("", 0);
        store.setImageDescription(imageDesc, 0);
        this.status("Reading extended header");
        this.in.seek(fp);
        this.setOffsetInfo(sequence, sizeZ, sizeC, sizeT);
        this.extHdrFields = new DVExtHdrFields[sizeZ][sizeC][sizeT];
        this.ndFilters = new Float[sizeC];
        boolean logFound = this.parseLogFile(store);
        this.parseDeconvolutionLog(store);
        int offset = 1024 + this.numIntsPerSection * 4;
        for (int i6 = 0; i6 < imageCount; ++i6) {
            DVExtHdrFields hdr;
            int[] coords = this.getZCTCoords(i6);
            int z = coords[0];
            int w = coords[1];
            int t = coords[2];
            this.in.seek(offset + this.getTotalOffset(z, w, t));
            this.extHdrFields[z][w][t] = hdr = new DVExtHdrFields(this.in);
            String prefix = "Extended header Z" + z + " W" + w + " T" + t;
            this.addMeta(prefix, hdr);
            if (!logFound) {
                store.setPlaneTimingDeltaT(new Float(hdr.timeStampSeconds), 0, 0, i6);
            }
            store.setPlaneTimingExposureTime(new Float(hdr.expTime), 0, 0, i6);
            if (logFound) continue;
            store.setStagePositionPositionX(new Float(hdr.stageXCoord), 0, 0, i6);
            store.setStagePositionPositionY(new Float(hdr.stageYCoord), 0, 0, i6);
            store.setStagePositionPositionZ(new Float(hdr.stageZCoord), 0, 0, i6);
        }
        for (int w = 0; w < sizeC; ++w) {
            DVExtHdrFields hdrC = this.extHdrFields[0][w][0];
            store.setLogicalChannelEmWave(new Integer(waves[w]), 0, w);
            store.setLogicalChannelExWave(new Integer((int)hdrC.exWavelen), 0, w);
            if (this.ndFilters[w] == null) {
                this.ndFilters[w] = new Float(hdrC.ndFilter);
            }
            store.setLogicalChannelNdFilter(this.ndFilters[w], 0, w);
        }
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    private boolean parseLogFile(MetadataStore store) throws IOException {
        String logFile = this.getCurrentFile() + ".log";
        if (!new Location(logFile).exists()) {
            return false;
        }
        RandomAccessStream s = new RandomAccessStream(logFile);
        String value = "";
        String prefix = "";
        int currentImage = 0;
        while (s.getFilePointer() < s.length() - 1L) {
            String line = s.readLine().trim();
            int colon = line.indexOf(":");
            if (colon != -1) {
                Float z;
                Float y;
                String key;
                if (line.startsWith("Created")) {
                    key = "Created";
                    value = line.substring(7).trim();
                } else {
                    key = line.substring(0, colon).trim();
                    value = line.substring(colon + 1).trim();
                }
                if (value.equals("") && !key.equals("")) {
                    prefix = key;
                }
                this.addMeta(prefix + " " + key, value);
                if (key.equals("Objective")) {
                    int space = value.indexOf(" ");
                    if (space == -1) continue;
                    String manufacturer = value.substring(0, space);
                    String extra = value.substring(space + 1);
                    String[] tokens = extra.split(",");
                    store.setObjectiveManufacturer(manufacturer, 0, 0);
                    String magnification = tokens[0].substring(0, tokens[0].indexOf("X"));
                    String na = tokens[0].substring(tokens[0].indexOf("/") + 1);
                    store.setObjectiveNominalMagnification(new Integer(magnification), 0, 0);
                    store.setObjectiveLensNA(new Float(na), 0, 0);
                    store.setObjectiveCorrection(tokens[1], 0, 0);
                    if (tokens.length <= 3) continue;
                    store.setObjectiveModel(tokens[3], 0, 0);
                    continue;
                }
                if (key.equals("Lens ID")) {
                    store.setObjectiveID("Objective:" + value, 0, 0);
                    store.setObjectiveSettingsObjective("Objective:" + value, 0);
                    continue;
                }
                if (key.equals("Pixel Size")) {
                    String[] pixelSizes = value.split(" ");
                    Float x = new Float(pixelSizes[0].trim());
                    y = new Float(pixelSizes[1].trim());
                    z = new Float(pixelSizes[2].trim());
                    store.setDimensionsPhysicalSizeX(x, 0, 0);
                    store.setDimensionsPhysicalSizeY(y, 0, 0);
                    store.setDimensionsPhysicalSizeZ(z, 0, 0);
                    continue;
                }
                if (key.equals("Binning")) {
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        store.setDetectorSettingsBinning(value, 0, c);
                        store.setDetectorType("Unknown", 0, c);
                        store.setDetectorID("Detector:" + c, 0, c);
                        store.setDetectorSettingsDetector("Detector:" + c, 0, c);
                    }
                    continue;
                }
                if (key.equals("Type")) {
                    store.setDetectorModel(value, 0, 0);
                    continue;
                }
                if (key.equals("Gain")) {
                    value = value.replaceAll("X", "");
                    store.setDetectorSettingsGain(new Float(value), 0, 0);
                    continue;
                }
                if (key.equals("Speed")) {
                    value = value.replaceAll("KHz", "");
                    float mhz = Float.parseFloat(value) / 1000.0f;
                    store.setDetectorSettingsReadOutRate(new Float(mhz), 0, 0);
                    continue;
                }
                if (key.equals("Temp Setting")) {
                    value = value.replaceAll("C", "").trim();
                    store.setImagingEnvironmentTemperature(new Float(value), 0);
                    continue;
                }
                if (key.equals("Time Point")) {
                    Float time = new Float(value.substring(0, value.indexOf(" ")));
                    store.setPlaneTimingDeltaT(time, 0, 0, currentImage);
                    continue;
                }
                if (key.equals("EM filter")) {
                    int cIndex = this.getZCTCoords(currentImage)[1];
                    store.setLogicalChannelName(value, 0, cIndex);
                    continue;
                }
                if (key.equals("ND filter")) {
                    try {
                        float nd = Float.parseFloat(value.replaceAll("%", ""));
                        nd = (float)Math.pow(10.0, -1.0f * nd);
                        int cIndex = this.getZCTCoords(currentImage)[1];
                        this.ndFilters[cIndex] = new Float(nd);
                    }
                    catch (NumberFormatException exc) {}
                    continue;
                }
                if (!key.equals("Stage coordinates")) continue;
                value = value.substring(1, value.length() - 1);
                String[] coords = value.split(",");
                Float x = new Float(coords[0].trim());
                y = new Float(coords[1].trim());
                z = new Float(coords[2].trim());
                store.setStagePositionPositionX(x, 0, 0, currentImage);
                store.setStagePositionPositionY(y, 0, 0, currentImage);
                store.setStagePositionPositionZ(z, 0, 0, currentImage);
                ++currentImage;
                continue;
            }
            if (line.startsWith("Image")) {
                prefix = line;
                continue;
            }
            if (!line.startsWith("Created")) continue;
            SimpleDateFormat parse = new SimpleDateFormat("EEE MMM  d HH:mm:ss yyyy");
            Date date = parse.parse(line.substring(8).trim(), new ParsePosition(0));
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            store.setImageCreationDate(fmt.format(date), 0);
        }
        s.close();
        return true;
    }

    private void parseDeconvolutionLog(MetadataStore store) throws IOException {
        int dot = this.getCurrentFile().lastIndexOf(".");
        String base = this.getCurrentFile().substring(0, dot);
        if (!new Location(base + "_log.txt").exists()) {
            return;
        }
        RandomAccessStream s = new RandomAccessStream(base + "_log.txt");
        boolean doStatistics = false;
        int cc = 0;
        int tt = 0;
        String previousLine = null;
        while (s.getFilePointer() < s.length() - 1L) {
            int index;
            String line = s.readLine().trim();
            if (line == null || line.length() == 0) continue;
            if (doStatistics) {
                String[] keys = line.split("  ");
                Vector<String> realKeys = new Vector<String>();
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].trim().length() <= 0) continue;
                    realKeys.add(keys[i].trim());
                }
                keys = realKeys.toArray(new String[0]);
                s.readLine();
                line = s.readLine().trim();
                while (line.length() != 0) {
                    String[] values = line.split(" ");
                    Vector<String> realValues = new Vector<String>();
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i].trim().length() <= 0) continue;
                        realValues.add(values[i].trim());
                    }
                    values = realValues.toArray(new String[0]);
                    try {
                        int zz = Integer.parseInt(values[0].trim()) - 1;
                        int index2 = this.getIndex(zz, cc, tt);
                        for (int i = 1; i < keys.length; ++i) {
                            this.addMeta("Plane " + index2 + " " + keys[i], values[i]);
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    line = s.readLine().trim();
                }
            } else {
                int index3 = line.indexOf(".\t");
                if (index3 != -1) {
                    String key = line.substring(0, index3).trim();
                    String value = line.substring(index3 + 2).trim();
                    while (key.endsWith(".")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (previousLine.endsWith("Deconvolution Results:") || previousLine.endsWith("open OTF")) {
                        this.addMeta(previousLine + " " + key, value);
                    } else {
                        this.addMeta(key, value);
                    }
                }
            }
            if (line.indexOf("correcting time point") != -1 && (index = line.indexOf("time point\t") + 11) > 10) {
                String t = line.substring(index, line.indexOf(",", index));
                tt = Integer.parseInt(t) - 1;
                index = line.indexOf("wavelength\t") + 11;
                if (index > 10) {
                    String c = line.substring(index, line.indexOf(".", index));
                    cc = Integer.parseInt(c) - 1;
                }
            }
            if (line.length() > 0 && line.indexOf(".") == -1) {
                previousLine = line;
            }
            doStatistics = line.endsWith("- reading image data...");
        }
        s.close();
    }

    private void readWavelength(int channel, MetadataStore store) throws FormatException, IOException {
        float min = this.in.readFloat();
        float max = this.in.readFloat();
        this.addMeta("Wavelength " + (channel + 1) + " min. intensity", min);
        this.addMeta("Wavelength " + (channel + 1) + " max. intensity", max);
        if (store instanceof IMinMaxStore) {
            ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(0, min, max, channel);
        }
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        private float oDFilter;
        public float photosensorReading;
        public float timeStampSeconds;
        public float stageXCoord;
        public float stageYCoord;
        public float stageZCoord;
        public float minInten;
        public float maxInten;
        public float expTime;
        public float ndFilter;
        public float exWavelen;
        public float emWavelen;
        public float intenScaling;
        public float energyConvFactor;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("photosensorReading: ");
            sb.append(this.photosensorReading);
            sb.append("\ntimeStampSeconds: ");
            sb.append(this.timeStampSeconds);
            sb.append("\nstageXCoord: ");
            sb.append(this.stageXCoord);
            sb.append("\nstageYCoord: ");
            sb.append(this.stageYCoord);
            sb.append("\nstageZCoord: ");
            sb.append(this.stageZCoord);
            sb.append("\nminInten: ");
            sb.append(this.minInten);
            sb.append("\nmaxInten: ");
            sb.append(this.maxInten);
            sb.append("\nexpTime: ");
            sb.append(this.expTime);
            sb.append("\nndFilter: ");
            sb.append(this.ndFilter);
            sb.append("\nexWavelen: ");
            sb.append(this.exWavelen);
            sb.append("\nemWavelen: ");
            sb.append(this.emWavelen);
            sb.append("\nintenScaling: ");
            sb.append(this.intenScaling);
            sb.append("\nenergyConvFactor: ");
            sb.append(this.energyConvFactor);
            return sb.toString();
        }

        private DVExtHdrFields(RandomAccessStream in) {
            block2: {
                try {
                    this.photosensorReading = in.readFloat();
                    this.timeStampSeconds = in.readFloat();
                    this.stageXCoord = in.readFloat();
                    this.stageYCoord = in.readFloat();
                    this.stageZCoord = in.readFloat();
                    this.minInten = in.readFloat();
                    this.maxInten = in.readFloat();
                    in.skipBytes(4);
                    this.expTime = in.readFloat();
                    this.ndFilter = in.readFloat();
                    this.exWavelen = in.readFloat();
                    this.emWavelen = in.readFloat();
                    this.intenScaling = in.readFloat();
                    this.energyConvFactor = in.readFloat();
                }
                catch (IOException e) {
                    if (!FormatHandler.debug) break block2;
                    LogTools.trace(e);
                }
            }
        }
    }
}

