/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.dev;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.poi.hssf.eventusermodel.HSSFEventFactory;
import loci.poi.hssf.eventusermodel.HSSFListener;
import loci.poi.hssf.eventusermodel.HSSFRequest;
import loci.poi.hssf.record.Record;
import loci.poi.poifs.filesystem.DocumentInputStream;
import loci.poi.poifs.filesystem.POIFSFileSystem;

public class EFBiffViewer {
    String file;

    public void run() throws IOException {
        RandomAccessStream fin = new RandomAccessStream(this.file);
        POIFSFileSystem poifs = new POIFSFileSystem(fin, 512);
        DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
        HSSFRequest req = new HSSFRequest();
        req.addListenerForAllRecords(new HSSFListener(){

            public void processRecord(Record rec) {
                System.out.println(rec.toString());
            }
        });
        HSSFEventFactory factory = new HSSFEventFactory();
        factory.processEvents(req, din);
    }

    public void setFile(String file2) {
        this.file = file2;
    }

    public static void main(String[] args) {
        if (args.length == 1 && !args[0].equals("--help")) {
            try {
                EFBiffViewer viewer = new EFBiffViewer();
                viewer.setFile(args[0]);
                viewer.run();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("EFBiffViewer");
            System.out.println("Outputs biffview of records based on HSSFEventFactory");
            System.out.println("usage: java loci.poi.hssf.dev.EBBiffViewer filename");
        }
    }
}

