/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatTools;
import loci.plugins.Util;

public class Slicer
implements PlugInFilter {
    public boolean canceled;
    private String arg;
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        int i;
        boolean sliceZ = false;
        boolean sliceC = false;
        boolean sliceT = false;
        String stackOrder = null;
        boolean keepOriginal = false;
        boolean hyperstack = false;
        if (this.arg == null || this.arg.trim().equals("")) {
            GenericDialog gd = new GenericDialog("Slicing options...");
            gd.addCheckbox("Split channels", false);
            gd.addCheckbox("Split Z slices", false);
            gd.addCheckbox("Split timepoints", false);
            gd.addCheckbox("Keep original stack", false);
            gd.addCheckbox("Open as HyperStack", false);
            gd.addChoice("Stack order", new String[]{"XYCZT", "XYCTZ", "XYZCT", "XYZTC", "XYTCZ", "XYTZC"}, "XYCZT");
            gd.showDialog();
            if (gd.wasCanceled()) {
                this.canceled = true;
                return;
            }
            sliceC = gd.getNextBoolean();
            sliceZ = gd.getNextBoolean();
            sliceT = gd.getNextBoolean();
            keepOriginal = gd.getNextBoolean();
            hyperstack = gd.getNextBoolean();
            stackOrder = gd.getNextChoice();
        } else {
            sliceZ = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"slice_z", (String)"false"));
            sliceC = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"slice_c", (String)"false"));
            sliceT = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"slice_t", (String)"false"));
            keepOriginal = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"keep_original", (String)"false"));
            hyperstack = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"hyper_stack", (String)"false"));
            stackOrder = Macro.getValue((String)this.arg, (String)"stack_order", (String)"XYCZT");
        }
        ImageStack stack = this.imp.getImageStack();
        if (stack.isVirtual()) {
            IJ.error((String)"Slicer plugin cannot be used with virtual stacks.\nPlease convert the virtual stack using Image>Duplicate.");
            return;
        }
        Calibration calibration = this.imp.getCalibration();
        Class<?> c = null;
        try {
            c = Class.forName("ij.CompositeImage");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.imp.getClass().equals(c)) {
            return;
        }
        int sizeZ = this.imp.getNSlices();
        int sizeC = this.imp.getNChannels();
        int sizeT = this.imp.getNFrames();
        int slicesPerStack = stack.getSize();
        if (sliceZ) {
            slicesPerStack /= sizeZ;
        }
        if (sliceC) {
            slicesPerStack /= sizeC;
        }
        if (sliceT) {
            slicesPerStack /= sizeT;
        }
        ImageStack[] newStacks = new ImageStack[stack.getSize() / slicesPerStack];
        for (i = 0; i < newStacks.length; ++i) {
            newStacks[i] = new ImageStack(stack.getWidth(), stack.getHeight());
        }
        for (i = 0; i < sizeZ * sizeC * sizeT; ++i) {
            int[] zct = FormatTools.getZCTCoords(stackOrder, sizeZ, sizeC, sizeT, stack.getSize(), i);
            int stackNdx = FormatTools.getIndex(stackOrder, sliceZ ? sizeZ : 1, sliceC ? sizeC : 1, sliceT ? sizeT : 1, newStacks.length, sliceZ ? zct[0] : 0, sliceC ? zct[1] : 0, sliceT ? zct[2] : 0);
            newStacks[stackNdx].addSlice(stack.getSliceLabel(i + 1), stack.getProcessor(i + 1));
        }
        for (i = 0; i < newStacks.length; ++i) {
            String title = this.imp.getTitle();
            int[] zct = FormatTools.getZCTCoords(stackOrder, sliceZ ? sizeZ : 1, sliceC ? sizeC : 1, sliceT ? sizeT : 1, newStacks.length, i);
            if (sliceZ) {
                title = title + " - Z=" + zct[0];
            }
            if (sliceT) {
                title = sliceZ ? title + " T=" + zct[2] : title + " - T=" + zct[2];
            }
            if (sliceC) {
                title = sliceZ || sliceT ? title + " C=" + zct[1] : title + " - C=" + zct[1];
            }
            ImagePlus p = new ImagePlus(title, newStacks[i]);
            p.setProperty("Info", this.imp.getProperty("Info"));
            p.setDimensions(sliceC ? 1 : sizeC, sliceZ ? 1 : sizeZ, sliceT ? 1 : sizeT);
            p.setCalibration(calibration);
            p.setFileInfo(this.imp.getOriginalFileInfo());
            if (IJ.getVersion().compareTo("1.39l") >= 0 && !(p instanceof CompositeImage)) {
                p.setOpenAsHyperStack(hyperstack);
            }
            if (this.imp.getClass().equals(c) && !sliceC && Util.checkVersion("1.39l", "ImageJ 1.39l or later is required to merge >8 bit or >3 channel data")) {
                try {
                    ReflectedUniverse r = new ReflectedUniverse();
                    r.exec("import ij.CompositeImage");
                    r.setVar("p", Util.reorder(p, stackOrder, "XYCZT"));
                    r.exec("c = new CompositeImage(p, CompositeImage.COMPOSITE)");
                    r.exec("c.show()");
                }
                catch (ReflectException e) {
                    ByteArrayOutputStream s = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(s));
                    IJ.error((String)s.toString());
                }
                continue;
            }
            p.show();
        }
        if (!keepOriginal) {
            this.imp.close();
        }
    }
}

