/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import java.util.HashSet;
import java.util.Iterator;

public final class Checker {
    public static final int BIO_FORMATS = 1;
    public static final int OME_JAVA_XML = 2;
    public static final int OME_JAVA_DS = 3;
    public static final int FORMS = 4;

    private Checker() {
    }

    public static boolean checkClass(String className) {
        try {
            Class.forName(className);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void checkLibrary(int library, HashSet missing) {
        switch (library) {
            case 1: {
                Checker.checkLibrary("loci.common.RandomAccessStream", "loci-common.jar", missing);
                Checker.checkLibrary("loci.formats.FormatHandler", "bio-formats.jar", missing);
                Checker.checkLibrary("loci.poi.poifs.filesystem.POIFSDocument", "poi-loci.jar", missing);
                Checker.checkLibrary("mdbtools.libmdb.MdbFile", "mdbtools-java.jar", missing);
                break;
            }
            case 2: {
                Checker.checkLibrary("ome.xml.OMEXMLNode", "ome-xml.jar", missing);
                break;
            }
            case 3: {
                Checker.checkLibrary("org.openmicroscopy.ds.DataServer", "ome-java.jar", missing);
                Checker.checkLibrary("org.apache.xmlrpc.XmlRpcClient", "xmlrpc-1.2-b1.jar", missing);
                Checker.checkLibrary("org.apache.commons.httpclient.HttpClient", "commons-httpclient-2.0-rc2.jar", missing);
                Checker.checkLibrary("org.apache.commons.logging.Log", "commons-logging.jar", missing);
                break;
            }
            case 4: {
                Checker.checkLibrary("com.jgoodies.forms.layout.FormLayout", "forms-1.0.4.jar", missing);
            }
        }
    }

    public static void checkLibrary(String className, String jarFile, HashSet missing) {
        if (!Checker.checkClass(className)) {
            missing.add(jarFile);
        }
    }

    public static boolean checkJava() {
        String version = System.getProperty("java.version");
        double ver = Double.parseDouble(version.substring(0, 3));
        if (ver < 1.4) {
            IJ.error((String)"LOCI Plugins", (String)"Sorry, the LOCI plugins require Java 1.4 or later.\nYou can download ImageJ with JRE 5.0 from the ImageJ web site.");
            return false;
        }
        return true;
    }

    public static boolean checkImageJ() {
        boolean success;
        try {
            String version = IJ.getVersion();
            success = version != null && version.compareTo("1.34") >= 0;
        }
        catch (NoSuchMethodError err) {
            success = false;
        }
        if (!success) {
            IJ.error((String)"LOCI Plugins", (String)"Sorry, the LOCI plugins require ImageJ v1.34 or later.");
        }
        return success;
    }

    public static boolean checkMissing(HashSet missing) {
        int num = missing.size();
        if (num == 0) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("The following librar");
        sb.append(num == 1 ? "y was" : "ies were");
        sb.append(" not found:");
        Iterator iter = missing.iterator();
        for (int i = 0; i < num; ++i) {
            sb.append("\n    " + iter.next());
        }
        String them = num == 1 ? "it" : "them";
        sb.append("\nPlease download ");
        sb.append(them);
        sb.append(" from the LOCI website at");
        sb.append("\n    http://www.loci.wisc.edu/software/");
        sb.append("\nand place ");
        sb.append(them);
        sb.append(" in the ImageJ plugins folder.");
        IJ.error((String)"LOCI Plugins", (String)sb.toString());
        return false;
    }
}

