function volumeDirs = getCroppedVolumeDirs(croppedVolumesPath)
% function volumeDirs = getVolumeDirs(croppedVolumesPath)
%
% function to get all the cropped volume directories in 
% a given project's cropped directory. This is required instead of looking
% for jpg files in the cropped directory as done for the
% 2D case.

% files = dir(fullfile(projectDirectory, filesep, 'Cropped'));
files = dir(croppedVolumesPath);

% Each volume is assumed to reside in its own directory, hence
% remove all the non-directory files from the list
volumeDirs = [];

for i = 1:length(files)
    if ~isequal(files(i).name, '.') && ...
            ~isequal(files(i).name, '..') && ...
            isdir(fullfile(croppedVolumesPath, files(i).name))

        volumeDirs = [volumeDirs, files(i)];
    end
end
