function figure_1_points_around_leaf
% function figure_1_points_around_leaf
%
% Example:
% 
% figure_1_points_around_leaf;
%
% Dr. A. I. Hanna (2007)
[filename, pathname] = uigetfile('*.temp_dat', 'Pick a Template file');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
end
template = load([pathname, filesep, filename], '-mat');
template = template.PMTemplate;
primaries = get(template, 'primaries');
edge = get(template, 'loops');
edge = edge{1};
pts = get(template, 'pts');
figh = figure;
set(figh, 'InvertHardCopy', 'off');
axish = gca;
ptcol = uisetcolor('Pick the Landmark Colour');
pricol = uisetcolor('Pick the Primary Colour');
hold(axish, 'on');
for i=1:size(edge,1)
    plot(axish, [pts(1,edge(i,1)), pts(1,edge(i,2))], [pts(2,edge(i,1)), pts(2,edge(i,2))], '-', 'Color', ptcol, 'MarkerFaceColor', ptcol, 'MarkerEdgeColor', ptcol, 'LineWidth', 2);
end
plot(axish, pts(1,:), pts(2,:), 'o', 'MarkerFaceColor', ptcol, 'MarkerEdgeColor', ptcol);
plot(axish, pts(1,primaries), pts(2,primaries), 'o', 'MarkerFaceColor', pricol, 'MarkerEdgeColor', pricol);
hold(axish, 'on');

axis(axish, 'image', 'ij');
set(axish, 'Visible', 'on');
