function [vs] = getHTVolume()
% [vs] = getHTVolume()
% Utility function to obtain a  volume structure to be used with
% the function hapticTool. hapticTool internally uses hapticToolMex which 
% in turn uses the h3d scene graph api 
% 
% Author: Johann Strasser
% Date: 070129 (YYMMDD)
% 
% Revision #1

vs.name = 'volume';
vs.parentTransform = 'world';
vs.volume = [];
vs.planes = 256;
% H3DApi assumes metres. Although we want to use microns, we have to scale
% by 1000 to have a sensible display size. Otherwise the needed global
% scale leads to problems with the fonts, which don't seem to be affected
% by the local scale required to counteract the global scaling.
vs.voxelSize = [0.001, 0.001, 0.001];
vs.scalarSurfaceFrictionMode = 'on';
vs.hapticChannel = 'green';