function TemplateMSR = point_model_template2MSR(pmt,Data)

pts=get(pmt,'pts');
primaries=get(pmt,'primaries');
loops=get(pmt,'loops');
%         if numel(loops>1)
%             fprintf(1,'WARNING: more than one ''loop'' use first loop only\n');
%         end
loops=loops{1};

MSRObject.OBJECT='FromAAM';
MSRObject.RENDERTYPE='MESH';
MSRObject.VERTCOUNT=size(pts,2);%40
MSRObject.VERT=pts'; %[40x3 double]
MSRObject.VERTLABEL=repmat({'Secondary'},size(pts,2),1);% {40x1 cell}
for i=1:length(primaries)
    MSRObject.VERTLABEL(primaries(i))={'Primary'};
end
if ~isempty(loops)
    MSRObject.EDGECOUNT=size(loops,1);%: 98
    MSRObject.EDGE=loops; %[98x2 int32]
    MSRObject.EDGELABEL=repmat({''},size(loops,1),1);%: {98x1 cell}
end
if isfield(Data.handles,'Facets')
    MSRObject.FACECOUNT=size(Data.handles.Facets.facs,1); %: 59
    MSRObject.FACE=Data.handles.Facets.facs; % [59x3 double]
    for i=1:length(Data.handles.Facets.labels)
        a(1)=Data.handles.Facets.labels{i,1};
        a(2)=Data.handles.Facets.labels{i,2};
        a(3)=Data.handles.Facets.labels{i,3};
        MSRObject.FACELABEL{i}=a; %: {59x1 cell};
    end
end

TemplateMSR.MSR_VERSION= '1.2';
        imageDirectory=get(Data.handles.AAM,'imageDirectory');
TemplateMSR.ORIGINALDATA={'PATH',fullfile(pwd,imageDirectory)};
TemplateMSR.SCALE=[1 1 1];% [24.6776 24.6776 24.6776]
TemplateMSR.TIME=0;
TemplateMSR.ALGORITHM='VolViewer rev218';
TemplateMSR.OBJECT{1}=MSRObject;%{[1x1 struct]}


end