function [wpts] = TPS_pts_warp(pts, ipts, opts, verbose)
% function [wpts] = TPS_pts_warp(pts, ipts, opts)
%
% This function implements the THIN PLATE SPLINE method of point warping.
% 
% Input Params:
%  pts - the set of points to be warped
%  ipts - the set of input pts that the image is to be warped to
%  opts - the set of input pts that the image is already registered to
%
% Dr. A. I. Hanna (2006).
w = [];
a = [];
if nargin<3
    return;
end
if nargin < 4
    verbose = 0;
end
[w, a, K] = pts2TPS_param(opts, ipts);
wpts = psi_tps(pts, a, w, ipts);
return;