function [option, scaling] = BuildAugmentedPointModelsDialog(varargin)
%
%   Dr. A. I. Hanna (2005) CMP, UEA, 2005.
error(nargchk(0,inf,nargin));
ad.option = [];
ad.scaling = [];
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');
handles = guihandles(fig);
%set(fig, 'Color', get(handles.uipanel1, 'BackgroundColor'))
% Set all the callback functions
set(handles.defaultbtn, 'callback', {@doDefault});
set(handles.adjustszbtn, 'callback', {@doAdjustSize});
set(handles.removesizebtn, 'callback', {@doRemoveSizeFromClass});
% Initialize the application data structure
ad.figMain = fig;
ad.handles = handles;
setappdata(0,'BuildAugmentedPointModelsDialogData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end

if isappdata(0,'BuildAugmentedPointModelsDialogData')
    ad = getappdata(0,'BuildAugmentedPointModelsDialogData');
    option = ad.option;
    scaling = ad.scaling;
    rmappdata(0,'BuildAugmentedPointModelsDialogData')
else
    % figure was deleted
    option = -1;
    scaling = -1;
end
return;
%%%
%
%%%
function doDefault(btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0,'BuildAugmentedPointModelsDialogData');
ad.option = 1;
ad.scaling = get(ad.handles.custom_scaling_chk, 'Value');
delete(gcbf);
setappdata(0,'BuildAugmentedPointModelsDialogData', ad);
%%%
%
%%%
function doAdjustSize(btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0,'BuildAugmentedPointModelsDialogData');
ad.option = 2;
ad.scaling = get(ad.handles.custom_scaling_chk, 'Value');
delete(gcbf);
setappdata(0,'BuildAugmentedPointModelsDialogData', ad);
%%%
%
%%%
function doRemoveSizeFromClass(btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0,'BuildAugmentedPointModelsDialogData');
ad.option = 3;
ad.scaling = get(ad.handles.custom_scaling_chk, 'Value');
delete(gcbf);
setappdata(0,'BuildAugmentedPointModelsDialogData', ad);
