function Faces11_place_fixed_points(filename,t,verbose)
%function set_faces11_borderpoints_hat_beard(t)
%
%from AAMToolbox create a new model based on faces8.temp_dat
%(This will automatically create
%cd into the required project folder and run the function
%
%set points 159 to 166 to the border of the cropped image
%
%name, name of _pm file with no path and _pm suffix
%t, 0 or empty do not pause after each edit set is identified
%verbose, default 0, otherwise report full details of assignments
%                    mistakes are very easy to make
%
%J.Andrew Bangham, 2005
if nargin<1
    filename='';
end
if nargin<2
    t=0;
end
if nargin<3
    verbose=0;
end
template_name='Faces11';
pathname=fullfile('PointModels',template_name);
d=dir(fullfile(pathname,'*_pm.mat'));

if verbose
    figure
end
if isempty(filename)
    for i=1:length(d)
        filename=d(i).name;
        edit_sets=process_file(pathname,filename,t,verbose);
    end
else
    edit_sets=process_file(pathname,filename,t,verbose);
end
% now insert the edit_sets into the template directory
filename=fullfile('Templates',[template_name,'.edit_sets']);
if verbose
    %check that all the points have been accounted for
    ind=[];
    for i=1:length(edit_sets),
        ind=[ind,edit_sets{i}.indexes];
    end
    s=sort(double(ind))
    diff(s)
end
save(filename,'edit_sets');
if verbose
    close
end

function edit_sets=process_file(pathname,filename,t,verbose)
disp(sprintf('working on %s file',filename));
pathfile=fullfile(pathname,filename);
if exist(pathfile)==2
    q=load(fullfile(pathname,filename));
    pts2=q.pts;
    if size(q.pts,2)==2
        x=q.pts(:,1);
        y=q.pts(:,2);
    else
        x=q.pts(1:2:end);
        y=q.pts(2:2:end);
    end
    disp('changing box points')
    file=filename(1:findstr(filename,'_pm')-1);
    im=imread(fullfile('Cropped',[file,'.jpg']));
    % a simple threshold
    mask1=im(:,:,1)>250 & im(:,:,2)>250 & im(:,:,3)>250;
    mask=imdilate(mask1,ones(7)); % bring the border in a little
    bb=regionprops(double(~mask),'boundingbox');
    bb=bb.BoundingBox;
    i=159;
    x(i)=round(bb(1)); y(i)=round(bb(2));% top left
    i=i+1;
    x(i)=round(bb(1)+bb(3)/2); y(i)=round(bb(2));% top middle
    i=i+1;
    x(i)=round(bb(1)+bb(3)); y(i)=round(bb(2));% top right
    i=i+1;
    x(i)=round(bb(1)+bb(3)); y(i)=round(bb(2)+bb(4)/2);% right middle
    i=i+1;
    x(i)=round(bb(1)+bb(3)); y(i)=round(bb(2)+bb(4));% bottom right
    i=i+1;
    x(i)=round(bb(1)+bb(3)/2); y(i)=round(bb(2)+bb(4));% bottom middle
    i=i+1;
    x(i)=round(bb(1)); y(i)=round(bb(2)+bb(4));% bottom left
    i=i+1;
    x(i)=round(bb(1)); y(i)=round(bb(2)+bb(4)/2);% left middle
    % now equivalence the hat points with hair
    hs=1;k=1;
    % ii indexes hat points and jj indexes hair points
    ii=199;jj=135;x(ii)=x(jj);y(ii)=y(jj);
    hat_peak_set(hs)=ii;hs=hs+1; % top centre
    hs=1;
    hair_set(k)=jj;k=k+1;
    ii=189;jj=135;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % middle
    ii=ii-1;jj=jj+1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % left 1
    hair_set(k)=jj;k=k+1;
    ii=ii-1;jj=jj+1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % left 2
    hair_set(k)=jj;k=k+1;
    ii=ii-1;jj=jj+1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % left 3
    hair_set(k)=jj;k=k+1;
    ii=ii-1;jj=jj+1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % left 4
    hair_set(k)=jj;k=k+1;
    ii=189;jj=135;
    ii=ii+1;jj=jj-1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % right 1
    hair_set(k)=jj;k=k+1;
    ii=ii+1;jj=jj-1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % right 2
    hair_set(k)=jj;k=k+1;
    ii=ii+1;jj=jj-1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % right 3
    hair_set(k)=jj;k=k+1;
    ii=ii+1;jj=jj-1;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % right 4
    hair_set(k)=jj;k=k+1;
    ii=185;jj=139;
    ii=ii-1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 1
    ii=ii-1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 2
    ii=ii-1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 3
    ii=ii-1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 4
    ii=193;jj=131;
    ii=ii+1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 1
    ii=ii+1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 2
    ii=ii+1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 3
    ii=ii+1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 4
    ii=ii+1;jj=jj;x(ii)=x(jj);y(ii)=y(jj);
    hat_set(hs)=ii;hs=hs+1; % 4
    for ii=130:-1:127,
        hair_set(k)=ii;k=k+1;
    end
    for ii=140:143,
        hair_set(k)=ii;k=k+1;
    end
    if verbose
        hair_set
        plot(x(hair_set),-y(hair_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
        hat_set
        plot(x(hat_set),-y(hat_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=1:32,
        face_border_set(k)=ii;k=k+1;
    end
    if verbose
        face_border_set
        plot(x(face_border_set),-y(face_border_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=34:45,
        mouth_set(k)=ii;k=k+1;
    end
    for ii=153:158,
        mouth_set(k)=ii;k=k+1;
    end
    if verbose
        mouth_set
        plot(x(mouth_set),-y(mouth_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=147:152,
        muzzle_set(k)=ii;k=k+1;
    end
    ii=33;muzzle_set(k)=ii;k=k+1;
    if verbose
        muzzle_set
        plot(x(muzzle_set),-y(muzzle_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=46:52,
        nose_set(k)=ii;k=k+1;
    end
    nose_set(k)=145;k=k+1;
    nose_set(k)=146;k=k+1;
    nose_set(k)=53;k=k+1;
    nose_set(k)=86;k=k+1;
    nose_set(k)=85;k=k+1;
    nose_set(k)=87;k=k+1;
    if verbose
        nose_set
        plot(x(nose_set),-y(nose_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=96:118,
        left_eye_set(k)=ii;k=k+1;
    end
    if verbose
        left_eye_set
        plot(x(left_eye_set),-y(left_eye_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=54:76,
        right_eye_set(k)=ii;k=k+1;
    end
    if verbose
        right_eye_set
        plot(x(right_eye_set),-y(right_eye_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=77:84,
        eyebrows_set(k)=ii;k=k+1;
    end
    for ii=88:95,
        eyebrows_set(k)=ii;k=k+1;
    end
    if verbose
        eyebrows_set
        plot(x(eyebrows_set),-y(eyebrows_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=171:175,
        ears_set(k)=ii;k=k+1;
    end
    for ii=176:180,
        ears_set(k)=ii;k=k+1;
    end
    if verbose
        ears_set
        plot(x(ears_set),-y(ears_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    ii=144;shoulders_neck_set(k)=ii;k=k+1;
    ii=169;shoulders_neck_set(k)=ii;k=k+1;
    ii=126;shoulders_neck_set(k)=ii;k=k+1;
    ii=170;shoulders_neck_set(k)=ii;k=k+1;
    for ii=119:125,
        shoulders_neck_set(k)=ii;k=k+1;
    end
    ii=167;shoulders_neck_set(k)=ii;k=k+1;
    ii=168;shoulders_neck_set(k)=ii;k=k+1;
    if verbose
        shoulders_neck_set
        plot(x(shoulders_neck_set),-y(shoulders_neck_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    k=1;
    for ii=159:166,
        border_set(k)=ii;k=k+1;
    end
    if verbose
        border_set
        plot(x(border_set),-y(border_set),'Ob');hold on;plot(x,-y,'.r');hold off;drawnow;pause(t);
    end
    eyes_nose_mouth_subset=[105,107,109,112,67,65,63,60,86,145,146,53,45,36,39,42];
    edit_sets{1}.indexes=ears_set;
    edit_sets{1}.label='Ears';
    edit_sets{2}.indexes=eyebrows_set;
    edit_sets{2}.label='Eyebrows';
    edit_sets{3}.indexes=left_eye_set;
    edit_sets{3}.label='Left eye';
    edit_sets{4}.indexes=right_eye_set;
    edit_sets{4}.label='Right eye';
    edit_sets{5}.indexes=hair_set;
    edit_sets{5}.label='Hair';
    edit_sets{6}.indexes=muzzle_set;
    edit_sets{6}.label='Muzzle';
    edit_sets{7}.indexes=mouth_set;
    edit_sets{7}.label='Mouth';
    edit_sets{8}.indexes=shoulders_neck_set;
    edit_sets{8}.label='Shoulders neck';
    edit_sets{9}.indexes=border_set;
    edit_sets{9}.label='Border';
    edit_sets{10}.indexes=face_border_set;
    edit_sets{10}.label='Face border';
    edit_sets{11}.indexes=hat_set;
    edit_sets{11}.label='Hat'; %hat_peak_set
    edit_sets{12}.indexes=hat_peak_set;
    edit_sets{12}.label='Hat peak'; %hat_peak_set
    edit_sets{13}.indexes=nose_set;
    edit_sets{13}.label='Nose';
    edit_sets{14}.indexes=eyes_nose_mouth_subset;
    edit_sets{14}.label='eyes_nose_mouth_subset';
    %         for i=1:length(edit_sets),if ~isempty(find(edit_sets{i}.indexes==182)),edit_sets{i}.label,end;end
    %         pause

    pts2(1:2:end)=x;
    pts2(2:2:end)=y;
    pts=pts2(:);
    %save(fullfile(pathname,filename),'pts');
else
    error('There are no point models to work on');
end


    