function [varargout] = aamio_getGroupPointModels(varargin)
% function [varargout] = aamio_getGroupPointModels(varargin)
%
% Dr. A. I. Hanna (2007)

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename,' must come param/value in pairs.'])
end
pm_dir = [pwd, filesep, 'PointModels'];
group = [];
templatename = '';
indices = [];
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'group'
            group = varargin{i+1};
        case 'templatename'
            templatename = varargin{i+1};
        case 'indices'
            indices = varargin{i+1};
        case 'pointmodeldir'
            pm_dir = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(group)
    error('Parameter group must be supplied');
end
if isempty(templatename)
    error('Parameter templatename must be supplied');
end
N = length(group.elements);
X = struct([]);
ThreeD = isProject3D(pwd);
for i=1:N
    pmfilename = ['PointModels', filesep, templatename, filesep, group.elements{i}];
    [pmpath, pmfilename] = fileparts(pmfilename);
    pmfilename = [pmpath, filesep, pmfilename];
    X(end+1).name = group.elements{i};
    X(end).pts = [];
    if exist([pmfilename, '.mat'], 'file')
        temp =load(pmfilename);
        if isfield(temp, 'pts')
            pts = temp.pts;
            if ThreeD
                pts = reshape(pts, 3, length(pts)/3); % This needs to recognise 3D
            else
                pts = reshape(pts, 2, length(pts)/2); % This needs to recognise 3D
            end
            if ~isempty(indices)
                pts = pts(:, indices);
            end
            X(end).pts = pts(:);
        end
    end
    if rem(i,10)==0
        disp([num2str(i),' / ',num2str(N)]);
    end
end
varargout{1} = X;
return;