function [files] = aamio_choosePointModelFilenames
% function varargout = aamio_choosePointModelFilenames
%
%
% Dr. A. I. Hanna (2007)
directoryname = uigetdir(pwd, 'Pick Directory Containing Point Models');
if directoryname == 0
    return;
end
files = dir([directoryname, filesep, '*.mat']);

files = {files.name};
[s,v] = listdlg('PromptString','Select point models to load:',...
    'SelectionMode','multiple',...
    'ListSize', [600 300],...
    'Name', 'Point Model File Chooser',...
    'ListString',files);
if isempty(s)
    return;
end
files = {files{s}};
num_files = length(files);
for i=1:num_files
    files{i} = [directoryname, filesep, files{i}];
end
return