function varargout = convertToRealSpaceTool(varargin)
% function varargout = convertToRealSpaceTool(varargin)
%
% Description:
%
% GUI tool to convert image space point models to real space point models
% based on the voxel size encoded in the point model name
%
% Author: Johann Strasser
% Date: 071218

originalPointModelName = {};
originalPointModelsDirectory = [];
outputDirectory = [];

if length(varargin)>1
    for i = 1:2:length(varargin)
        switch(lower(varargin{i}))
            case 'originalpointmodelsdirectory'
                originalPointModelsDirectory = varargin{i + 1};
            case 'outputdirectory'
                outputDirectory = varargin{i + 1};
            otherwise
                error(['Unknown parameer name passed to ', mfilename, '.  Name was ' varargin{i}]);
        end
    end
end


if isempty(originalPointModelsDirectory)
    originalPointModelsDirectory = uigetdir(pwd, 'Select directory containing original point models.');
end

if isequal(originalPointModelsDirectory, 0)
    disp(sprintf('%s:  user aborted.', mfilename));
    return;
else
    % Get all the originalVolume directories
    files = dir(originalPointModelsDirectory);
    files = files([files.isdir] == 0);
    originalPointModelName = {files.name};

    [orignalBatchDirParentDir, name, ext, versn] = fileparts(originalPointModelsDirectory);

    outputDirectory = uigetdir(originalPointModelsDirectory, ['Select or create output directory. ', 'Choose directory']);

    if isequal(outputDirectory, 0)
        disp(sprintf('%s:  user aborted.', mfilename));
        return;
    end
end


for i = 1:length(originalPointModelName)
    
    [voxelSize, found, voxelSizeString] = getVoxelSizeFromString('string', originalPointModelName{i});
    
    load(fullfile(originalPointModelsDirectory, originalPointModelName{i}), 'pts');
    pts = reshape(pts, 3, length(pts) / 3);
    scaleMat = diag(voxelSize);
    pts = scaleMat * pts;    
    pts = pts(:);
    save(fullfile(outputDirectory, originalPointModelName{i}), 'pts');
end



% varargout{1} = volumeResized;
%
% if ~isempty(voxelSize)
%     varargout{2} = resizedVoxelSize;
% else
%     varargout{2} = [];
% end