function saveSimpleShapeedi(shapedir, pmdir, template, I)
[filename, pathname] = uiputfile(['Cropped', filesep, '*.jpg'], 'Pick an JPG-file');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
else
    disp(['User selected ', fullfile(pathname, filename)])
    imwrite(I, [pathname, filesep, filename], 'JPEG');
end

% next we must assume that the points are in order. next we ask the user to
% click on the primaries in order and fill in the gaps.

figh = figure;
axish = gca;
hold(axish, 'on');
edge = bwboundaries(I(:,:,1), 8);
edge = fliplr(edge{1});
pts = get(template, 'pts');
pri = sort(get(template, 'primaries'));

imagesc(I, 'Parent', axish);
axis(axish, 'image', 'ij');
[x, y] = ginput(1);

d = sqrt(sum((edge - ones(size(edge,1),1)*[x, y]).^2,2));
[val, ind] = min(d); ind = ind(1);
edge = [edge(ind:end,:); edge(1:ind-1,:)];

ind = round(linspace(1,size(edge,1), size(pts,2)+1));
ind = ind(1:end-1);
pts = edge(ind,:);
plot(axish, pts(:,1), pts(:,2), 'ro');

[filepath, filename, ext, vers] = fileparts(filename);
pts = pts';
pts = pts(:);
ptsfilename = [pmdir, filesep, filename, '_pm.mat'];
save(ptsfilename, 'pts');



