function [X, files] = aamio_loadPointModels(varargin)
% function varargout = aamio_loadPointModels(varargin)
%
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
files = {};
X = [];
str = 'Open Point Model';
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'filenames'
            files = varargin{i+1};
        case 'title'
            str = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(files)
   [files] = aamio_choosePointModelFilenames;
end
num_files = length(files);
for i=1:num_files
    pm = aamio_loadPointModel('filename', files{i}, 'title', str);
    if ~isempty(pm)
        if isempty(X)
            X = pm(:);
            num_pts = size(X,1);
        else
            if length(pm(:))==num_pts
                X = cat(2, X, pm(:));
            else
                fprintf('%s has the wrong number of points, ignoring\n', files{i});
            end
        end

    end
end
return