function theta = vecangle( a, b, n )
%theta = vecangle( a, b )
%   Return the angle between two row vectors.  If
%   n is not supplied, the answer will always be in the range 0..pi.  If n is
%   supplied then the answer will be in the range -pi..pi, with the sign
%   positive if the triple (a,b,n) is right-handed and negative if
%   left-handed.
%   a, b, and n can also be N*3 matrices, and theta will be an N*1 vector
%   of angles.

    if size(a,2)==2
        a = [a,zeros(size(a,1))];
        b = [b,zeros(size(b,1))];
    end
    c = dotproc2(a,b);
    cab = crossproc2(a,b);
    s = sqrt( sum( cab.^2, 2 ) );
    if nargin >= 3
        s = s .* sign( dotproc2( cab, n ) );
    end
    theta = atan2( s, c );
end
