function m = establishInteractionMode( m, clickMode, varargin )
%m = establishInteractionMode( m, clickMode, varargin )
%   Set the interaction mode.  If the current mode is compatible with the
%   new mode, is should be updated as necessary with the extra arguments.
%   Otherwise, it should be replaced by the new mode.
%   The extra arguments have the same significance as in
%   setInteractionMode.

% fprintf( 1, 'establishInteractionMode %s\n', clickMode );
    if (~isempty(m)) && ~compatibleInteractionMode( m, clickMode, varargin{:} )
        m = setInteractionMode( m, clickMode, varargin{:} );
    end
end
