function [m,numElided] = tryElideEdge( m, threshold )
%[m,numElided] = tryElideEdge( m )
%   Attempts to find an edge of m to elide.  It first assesses the quality
%   of each edge (the minimum angle of the cells incident on it), arranges
%   those falling below a threshold in increasing order, and then attempts
%   to elide each one in turn until one succeeds.  Elision fails if either
%   it would result in an invalid mesh, or if it would reduce the quality
%   of any cell to a value below the threshold.

    go_on = true;
    numElided = 0;
    pass = 0;
    while go_on
        pass = pass+1;
        fprintf( 1, 'Elide edges pass %d.\n', pass );
      % [eis,qualities] = findEdgesToElide( m, threshold );
        [sharpedges,shallowedges] = findElidableEdges( m, 1.3*threshold );
        fprintf( 1, 'Sharp %d, shallow %d.\n', ...
            numel(sharpedges), numel(shallowedges) );
        if isempty(sharpedges)
            fprintf( 1, 'Elide edges: no candidates.\n' );
            break;
        end
        go_on = false;
        i = 1;
        numthispass = 0;
        while i <= length(sharpedges)
            ei = sharpedges(i);
          % fprintf( 1, '%s: attempting edge %d\n ', mfilename(), ei );
            [m,elided,renumberedges] = elideEdge(m,ei,threshold);
            if elided
                numthispass = numthispass+1;
                sharpedges = renumberedges( sharpedges( (i+1):end ) );
                sharpedges = sharpedges(sharpedges ~= 0);
                i = 1;
                go_on = true;
            else
                i = i+1;
            end
        end
        numElided = numElided + numthispass;
        fprintf( 1, 'Elide edge pass %d: %d edges elided.\n', pass, numthispass );
    end
    if numElided==0;
      % fprintf( 1, 'No edges could be elided.\n' );
    else
        [ok,m] = validmesh(m);
        if ~ok
            error('Oops!');
        end
      % fprintf( 1, 'Elided %d edges.\n', numElided );
    end
end
