function [cmap,crange] = stresscolormap( maxval )
    if length(maxval)==2
        maxval = maxval(2);
    end
    cmap = [ ...
        colorStep( [1 1 1], [0 0 1], 10, 0, 1 );
        colorStep( [0 0 1], [0 1 1],  5, 0, 1 );
        colorStep( [0 1 1], [0 1 0],  5, 0, 1 );
        colorStep( [0 1 0], [1 1 0], 10, 0, 1 );
        colorStep( [1 1 0], [1 0 0], 10, 0, 1 );
        colorStep( [1 0 0], [1 0 1], 50, 0, 1 );
        colorStep( [1 0 1], [0 0 0], 10, 0, 0 ) ];
    if maxval <= 10
        crange = [0 10];
    else
        if maxval >= 1000
            maxval = 1000;
        end
        crange = [0 maxval];
        extra = ceil((maxval-10)*size(cmap,1)/10);
        extramap = ones(extra,3)*0.3;
        cmap = [cmap; extramap ];
    end
end
