function secondlayer = deleteSecondLayerCells( secondlayer, cellsToDelete )
%secondlayer = deleteSecondLayerCells( secondlayer, cellsToDelete )
%   cellToDelete is a bitmap of the cells to delete from the second layer.
    numcells = length( secondlayer.cells );
    numedges = size( secondlayer.edges, 1 );
    numvxs = length( secondlayer.vxFEMcell );

    cellMap = true(1,numcells);
    cellMap(cellsToDelete) = false;
    cellsToKeep = find(cellMap);

    % Find all vertexes that belong to any retained cell.
    retainedVxMap = false(1,numvxs);
    for i=cellsToKeep
        retainedVxMap(secondlayer.cells(i).vxs) = true;
    end
    
    [ newToOldVx, oldToNewVx ] = makeRenumbering( retainedVxMap );
    secondlayer.vxFEMcell = secondlayer.vxFEMcell( retainedVxMap );

    secondlayer.vxBaryCoords = secondlayer.vxBaryCoords( retainedVxMap, : );
    secondlayer.cell3dcoords = secondlayer.cell3dcoords( retainedVxMap, : );
    
    secondlayer.cloneindex = secondlayer.cloneindex( cellsToKeep );
    secondlayer.side = secondlayer.side( cellsToKeep );
    secondlayer.cellarea = secondlayer.cellarea( cellsToKeep );
    secondlayer.areamultiple = secondlayer.areamultiple( cellsToKeep );
    secondlayer.celltargetarea = secondlayer.celltargetarea( cellsToKeep );
    
    [ newToOldCell, oldToNewCell ] = makeRenumbering( cellMap );
    
    % Find all edges that belong to any retained cell.
    testEdge = false( 1, numedges );
    for ei=1:numedges
        testEdge(ei) = ...
            cellMap( secondlayer.edges( ei, 3 ) ) ...
            || ( (secondlayer.edges( ei, 4 ) ~= 0) ...
                 && cellMap( secondlayer.edges( ei, 4 ) ) );
    end
    [ newToOldEdge, oldToNewEdge ] = makeRenumbering( testEdge );
    secondlayer.generation = secondlayer.generation( testEdge );
   
    % edges
    secondlayer.edges = secondlayer.edges( testEdge, : );
    numedges = size( secondlayer.edges, 1 );
    secondlayer.edges(:,1:2) = renumberArray( secondlayer.edges( :, 1:2 ), oldToNewVx );
    for ei=1:numedges
        ci1 = secondlayer.edges(ei,3);
        if ci1==0
            fprintf( 1, 'deleteFemToSecondLayer: error, edge %d invalid: ', ei );
            fprintf( 1, ' %d', secondlayer.edges(ei,:) );
            fprintf( '\n' );
        end
        ci2 = secondlayer.edges(ei,4);
        ci1a = oldToNewCell(ci1);
        if ci2 ~= 0
            ci2a = oldToNewCell(ci2);
        else
            ci2a = 0;
        end
        if ci1a==0
            ci1a = ci2a;
            ci2a = 0;
        end
        secondlayer.edges(ei,3:4) = [ ci1a, ci2a ];
    end

    % cells
    secondlayer.cells = secondlayer.cells( cellMap );
    % cellcolor
    if ~isempty( secondlayer.cellcolor )
        secondlayer.cellcolor = secondlayer.cellcolor( cellMap, : );
    end
    numcells = length( secondlayer.cells );
    % cells().vxs
    % cells().edges
    for ci=1:numcells
        secondlayer.cells(ci).vxs = oldToNewVx( secondlayer.cells(ci).vxs );
        secondlayer.cells(ci).edges = oldToNewEdge( secondlayer.cells(ci).edges );
    end

    ok = checkclonesvalid( secondlayer );
end

