function saveStaticPart( m )
%saveStaticPart( m )
%   If m is the mesh of a project, save its static part.
    if ~isfield(m.globalDynamicProps,'staticreadonly')
        m.globalDynamicProps.staticreadonly=false;
    end
    if m.globalDynamicProps.staticreadonly
        return;
    end
    staticbasename = staticBaseName( m );
    if isempty(staticbasename)
        return;
    end
    staticfullname = fullfile( getModelDir( m ), staticbasename );
    setGlobals();
    global gFULLSTATICFIELDS
    mstatic = splitstruct( m, gFULLSTATICFIELDS );
    %try
        save( staticfullname, '-struct', 'mstatic' );
        fprintf( 1, 'Static file %s updated.\n', staticbasename );
%     catch exc
%         fprintf( 1, '** Failed to save static file %s in folder %s.\n%s', ...
%             staticbasename, staticfullname, getReport( exc ) );
%         
%     end
end
