function m = rotateAllTensors( m, r, cells )
    if nargin < 3
        cells = 1:length(m.celldata);
    end
    if size(r,3)==1
        r = repmat( r, [1, 1, length(cells)] );
    end
    for i=1:length(cells)
        ci = cells(i);
        m.celldata(ci).eps0gauss = ...
            rotateGrowthTensor( m.celldata(ci).eps0gauss', r(:,:,i) )';
        m.celldata(ci).cellThermExpGlobalTensor = ...
            rotateGrowthTensor( m.celldata(ci).cellThermExpGlobalTensor', r(:,:,i) )';
        m.celldata(ci).actualGrowthTensor = ...
            rotateGrowthTensor( m.celldata(ci).actualGrowthTensor', r(:,:,i) )';
        m.celldata(ci).displacementStrain = ...
            rotateGrowthTensor( m.celldata(ci).displacementStrain', r(:,:,i) )';
        m.celldata(ci).residualStrain = ...
            rotateGrowthTensor( m.celldata(ci).residualStrain', r(:,:,i) )';
    end
    if isfield( m, 'cellFrames' )
        for i=1:length(cells)
            ci = cells(i);
            m.cellFrames(:,:,ci) = r(:,:,i) * m.cellFrames(:,:,ci);
        end
    end
end
