function [m,displacements] = restorethickness( m, displacements )
    numnodes = size( m.nodes, 1 );
    numpnodes = size( m.prismnodes, 1 );
    delta = m.prismnodes( 1:2:(numpnodes-1), : ) - ...
        m.prismnodes( 2:2:numpnodes, : );
    oldthicknessAbsolute = m.globalDynamicProps.thicknessAbsolute;
    m = setThickness( m );
    if false
        fprintf( 1, 'restorethickness area %.3f relative %.3f oldabs %.3f newabs %.3f area %.3f\n', ...
        m.globalProps.thicknessArea, ...
        m.globalProps.thicknessRelative, ...
        oldthicknessAbsolute, ...
        m.globalDynamicProps.thicknessAbsolute, ...
        m.globalDynamicProps.currentArea );
    end
    for i=1:numnodes
        len = norm(delta(i,:));
        if len ~= 0
            delta(i,:) = delta(i,:) * ((1 - m.globalDynamicProps.thicknessAbsolute/len)/2);
        end
    end
    m.prismnodes( 1:2:(numpnodes-1), : ) = ...
        m.prismnodes( 1:2:(numpnodes-1), : ) - delta;
    m.prismnodes( 2:2:numpnodes, : ) = ...
        m.prismnodes( 2:2:numpnodes, : ) + delta;
    if (nargin > 1) && (nargout > 1)
        displacements( 1:2:(numpnodes-1), : ) = ...
            displacements( 1:2:(numpnodes-1), : ) + delta;
        displacements( 2:2:numpnodes, : ) = ...
            displacements( 2:2:numpnodes, : ) - delta;
    end
end
