function v = insertFixedDFS( v, renumber, numfulldfs, ...
    stitchDFs, oppositePairs, stitchPairs, oppMoves, rowsToFix, fixedMoves )
%v = insertFixedDFS( v, renumber, numfulldfs, stitchDFs,  oppositePairs, )
%    v is a vector indexed by reduced degrees of freedom.
%    Insert zeros into v so that it is indexed by the full degrees of
%    freedom.

    if ~isempty(renumber)
        result = zeros( numfulldfs, 1 );
        result( renumber ) = v;
        v = result;
    end
    for i=1:length(stitchDFs)
        vxs = stitchDFs{i};
        v(vxs(2:end)) = v(vxs(1));
    end
    if ~isempty(stitchPairs)
        v(stitchPairs(:,2)) = v(stitchPairs(:,1));
    end
    if ~isempty(oppositePairs)
        v(oppositePairs(:,2)) = -v(oppositePairs(:,1));
        v(oppositePairs(:,1)) = v(oppositePairs(:,1)) + oppMoves;
        v(oppositePairs(:,2)) = v(oppositePairs(:,2)) + oppMoves;
    end
    if ~isempty( fixedMoves )
        v(rowsToFix) = fixedMoves;
    end
end
