function [mp,ok] = getMeshParams( h )
%mp = getMeshParams( h )
%   Get the currently selected mesh type and read all of its parameters
%   from the GUI.

    global MESH_PARAMS
    meshTypeHandle = h.generatetype;
    meshTypes = get( meshTypeHandle, 'String' );
    meshType = lower( meshTypes{ get(meshTypeHandle, 'Value') } );
    meshType = regexprep( meshType, ' ', '' );
    ok = true;
    if ~isfield( MESH_PARAMS, meshType )
        % Oops.
        ok = false;
        mp = struct();
    else
        mpspec = MESH_PARAMS.(meshType);
        fns = fieldnames(mpspec);
        for i=1:length(fns)
            fn = fns{i};
            paramspec = mpspec.(fn);
            if isstruct(paramspec)
                tag = sprintf( 'geomparam%d%d', paramspec.row, paramspec.col );
                if isfield( h, tag )
                    [val,ok1] = getDoubleFromDialog( h.(tag) );
                    if ~ok1
                        val = paramspec.dft;
                    end
                    mp.(fn) = val;
                else
                    mp.(fn) = paramspec.default;
                end
            end
        end
        if isfield( mpspec, 'constructor' )
            mp.constructor = mpspec.constructor;
        else
            mp.constructor = lower( mpspec.menuname );
        end
    end
end
