function handles = drawHistory( handles )
return;
    if ishandle(handles.historyPicture)
        hpos = get( handles.historyPicture, 'Position' );
        if handles.havemesh && isfield( handles.mesh, 'projectDirectory' )
            handles.historyImage = treeimage( handles.mesh.history, hpos(4), hpos(3) );
            handles.maxHistoryOffset = maxoffset( hpos([4 3]), ...
                [ size( handles.historyImage, 1 ), ...
                size( handles.historyImage, 2 ) ] );
            handles.historyImageOffset = min( handles.historyImageOffset, handles.maxHistoryOffset );
        else
            handles.historyImage = uint8( ones( [ hpos(4), hpos(3), 3 ] ) * 255 );
            handles.maxHistoryOffset = [0 0];
            handles.historyImageOffset = [0 0];
        end
        ylo = handles.historyImageOffset(1)+1;
        yhi = handles.historyImageOffset(1) + hpos(4);
        xlo = handles.historyImageOffset(2)+1;
        xhi = handles.historyImageOffset(2) + hpos(3);
        handles = drawHistoryImage( handles, xlo, xhi, ylo, yhi );
        guidata( handles.output, handles );
    end
end

function offset = maxoffset( boxsize, imagesize )
    offset = max( imagesize - boxsize, [0 0] );
end
