function doMeshClick( varargin )
    if nargin < 1, return; end
    hitObject = varargin{1};
    handles = guidata( hitObject );
    if ~isstruct(handles)
        % Not running in GFtbox.
        return;
    end
    if (~isfield( handles, 'mesh' )) || isempty( handles.mesh )
        return;
    end
  % fprintf( 1, '%s: clickMode = %s\n', mfilename, handles.mesh.interactionMode.clickMode );
    switch handles.mesh.interactionMode.clickMode
        case { '----', 'morph----' }
            dragviewButtonDownFcn( handles.picture, [] );
            return;
    end
    if isfield( handles, 'runFlag' ) && get( handles.runFlag, 'Value' )
        beep;
        fprintf( 1, '** Cannot edit leaf while simulation in progress.\n' );
        return;
    end
    parent = get( hitObject, 'Parent' );
    [pt, bc, vout, viout, facevout, faceiout] = select3d( hitObject );
    if isempty( pt )
        return;
    end
    ud = get( hitObject, 'Userdata' );
    fprintf( 1, '%s: faceiout %d, length(ud.faceindexes) %d\n', ...
        mfilename(), faceiout, length(ud.faceindexes) );
    ci = ud.faceindexes(faceiout);
    selectionType = getSelectionType( hitObject );

    output = handles.output;
    switch handles.mesh.interactionMode.clickMode
        case { '----', 'morph----' }
            % Should forward.
          % dragviewButtonDownFcn( handles.picture, [] );
        case ''
            % Nothing.
        case 'Delete element'
            attemptCommand( handles, false, true, ... % WARNING: Does not always need redraw.
                'deletepatch', ci );
            handles = guidata( output );
            handles = GUIPlotMesh( handles );
        case 'bioBedit'
            attemptCommand( handles, false, false, ...
                'addbioregion', ci );
            handles = guidata( output );
            handles = GUIPlotMesh( handles );
        case 'Subdivide element'
            fprintf( 1, '** Manual subdivision not implemented yet.\n' );
            % Subdivide the cell into four, and split each of the
            % neighbouring cells.
        case { 'Current mgen', 'morphAdd', 'morphSet', 'morphFix', ...
               'Fix nodes', 'Locate node', 'Subdivide node' }
            % Really a vertex click.
            % Find the hit point and take the closest vertex.
            [mbc,cvi] = max(bc);
            vi = handles.mesh.tricellvxs(ci,cvi);
            handles = vertexClick( handles, vi, selectionType );
        case { 'showvalue' }
            if false
                % Come here if the plot mode is per-cell and display
                % the value for the hit cell.
            else
                % Really a vertex click.
                % Find the hit point and take the closest vertex.
                [mbc,cvi] = max(bc);
                vi = handles.mesh.tricellvxs(ci,cvi);
                handles = vertexClick( handles, vi, selectionType );
            end
        case { 'Seam edges', 'Subdivide edge', 'Elide edge', 'Elide cell pair' }
            % Really an edge click.
            % Find the hit point and take the closest edge = the most
            % distant vertex.
            [mbc,cei] = min(bc);
            ei = handles.mesh.celledges(ci,cei);
            handles = edgeClick( handles, ei, selectionType );
        otherwise
            fprintf( 1, 'cellClick: unknown action %s.\n', ...
                handles.mesh.interactionMode.clickMode );
    end

    guidata( parent, handles );
end
