function deleteAllStagesItem_Callback(hObject, eventdata)
    handles = guidata( hObject );
    if isempty( handles.mesh )
        return;
    end
	if isempty(handles.mesh.globalProps.projectdir)
        complain( 'No project.' );
        return;
    end
    deleteTimes = strcmp( get( hObject, 'Tag' ), 'deleteStagesAndTimesItem' );
    if deleteTimes
        answer = questdlg(['Delete all stage files and times?'], ...
                           '', ...
                           'Yes','No','No' );
    else
        answer = questdlg(['Delete all stage files?'], ...
                           '', ...
                           'Yes','No','No' );
    end
    if ~strcmp(answer,'Yes')
        return;
    end
    handles.mesh = leaf_deletestages( handles.mesh, 'stages', true, 'times', deleteTimes );
    handles = remakeStageMenu( handles );
    setMeshFigureTitle( handles.output, handles.mesh );
    guidata( handles.output, handles );

