function mesh = computeGNGlobal( mesh )
%mesh = computeGNGlobal( mesh )
%   Compute the gradients of the shape functions in the global frame, at
%   every gauss point in every cell.

    numCells = size(mesh.tricellvxs,1);
    for ci=1:numCells
        trivxs = mesh.tricellvxs(ci,:);
        prismvxs = [ trivxs*2-1, trivxs*2 ];
        cellvxCoords = mesh.prismnodes( prismvxs, : )';
        mesh.celldata(ci).gnGlobal = ...
            computeCellGNGlobal( cellvxCoords, mesh.globalProps.gaussInfo );
    end
end
