function m = leaf_mgen_random( m, varargin )
%m = leaf_mgen_random( m, morphogen, amount, ... )
%   Add a random amount of a specified morphogen at each mesh point.
%   Arguments:
%   1: The name or index of a morphogen.
%   2: The maximum amount of morphogen to add to every node.
%   Options:
%       'smooth'        An integer specifying the smoothness of the
%                       distribution.  0 means no smoothing: the value at
%                       each node is independent of each of its neighbours.
%                       Greater values imply more smoothness.  Default is
%                       2.
%   Examples:
%       m = leaf_mgen_random( m, 'growth', 1 );
%       m = leaf_mgen_random( m, 'g_anisotropy', 0.8 );
%   See also: LEAF_MGEN_CONST.
%
%   Equivalent GUI operation: clicking the "Add random" button in the
%   "Morphogens" panel.  The amount is specified by the "Amount slider and
%   test item.
%
%   Topics: Morphogens.

    if isempty(m), return; end
    [ok1, morphogen, args] = getTypedArg( mfilename(), {'numeric','char'}, varargin );
    if ok1
        [ok2, amount, args] = getTypedArg( mfilename(), 'double', args );
    end
    if ~(ok1 && ok2), return; end
    
    [s,ok] = safemakestruct( mfilename(), args );
    if ~ok, return; end
    s = defaultfields( s, 'smoothness', 2 );
    ok = checkcommandargs( mfilename(), s, 'exact', 'smoothness' );
    if ~ok, return; end
    
    g = FindMorphogenIndex( m, morphogen, mfilename() );
    for i=1:length(g)
        m = addrandomfield( m, amount, g(i), s.smoothness, 1 );
    end
end
