function m = leaf_mgen_const( m, varargin )
%m = leaf_mgen_const( m, morphogen, amount )
%   Add a constant amount to the value of a specified morphogen everywhere.
%   Arguments:
%   1: The name or index of a morphogen.  Currently, if
%      the name is provided, it must be one of the following:
%          'growth', 'polariser', 'anisotropy',
%          'bend', 'bendpolariser', 'bendanisotropy'.
%      These are respectively equivalent to the indexes 1 to 6 (which
%      are the only valid indexes).  There is no default for this option.
%   2: The amount of morphogen to add to every node.  A value
%      of 1 will give moderate growth or bend, and a maximum growth or
%      bend anisotropy.  A constant field of growth or bend polarizer
%      has no effect: polarising morphogen has an effect only through
%      its gradient.
%   Examples:
%       m = leaf_mgen_const( m, 'growth', 1 );
%       m = leaf_mgen_const( m, 3, 0.8 );
%   See also: LEAF_MGEN_RADIAL.
%
%   Equivalent GUI operation: clicking the "Add const" button in the
%   "Morphogens" panel.  The amount is specified by the "Amount slider and
%   test item.
%
%   Topics: Morphogens.

    if isempty(m), return; end
    [ok1, morphogen, args] = getTypedArg( mfilename(), {'numeric','char'}, varargin );
    if ok1
        [ok2, amount, args] = getTypedArg( mfilename(), 'double', args );
    end
    if ~(ok1 && ok2), return; end
    if ~isempty(args)
        fprintf( 1, '%s: %d extra arguments ignored.\n', mfilename(), length(args) );
    end
    
    g = FindMorphogenIndex( m, morphogen, mfilename() );
    for i=1:length(g)
        m = setconstantfield( m, amount, g(i), 1 );
    end
end
