function m = leaf_icosahedron( m, varargin )
%m = leaf_icosahedron( m, ... )
%   Create a new icosahedral mesh.
%
%   Arguments:
%       M is either empty or an existing mesh.  If it is empty, then an
%       entirely new mesh is created, with the default set of morphogens
%       If M is an existing mesh, then its geometry is replaced by the new
%       mesh.  It retains the same set of morphogens (all set to zero
%       everywhere on the new mesh), interaction function, and all other
%       properties not depending on the specific geometry of the mesh.
%
%   Options:
%       'radius'        The radius of the icosahedron.  Default 1.
%
%   Example:
%       m = leaf_circle( [], 'radius', 2, 'rings', 4 );
%
%   Equivalent GUI operation: selecting "Circle" or "Hemisphere" on the
%   pulldown menu on the "Mesh editor" panel, and clicking the "Generate
%   mesh" button.
%
%   Topics: Mesh creation.

    [s,ok] = safemakestruct( mfilename(), varargin );
    if ~ok, return; end
    setGlobals();
    global gMAX_MGENVERSION
    s = defaultfields( s, 'radius', 1, ...
        'version', gMAX_MGENVERSION );
    ok = checkcommandargs( mfilename(), s, 'exact', ...
        'radius', 'version' );
    if ~ok, return; end
    
    newm = newicosmesh();
    newm.nodes = newm.nodes * s.radius;
    m = setmeshfromnodes( newm, m, s.version );
    m.meshparams = s;
    m.meshparams.randomness = 0;
    m.meshparams.type = regexprep( mfilename(), '^leaf_', '' );
end

