function C = IsotropicComplianceMatrix( K, nu )
%C = IsotropicComplianceMatrix( K, nu )
%   Compute the 6*6 compliance matrix for an isotropic material with bulk
%   modulus K and Poisson's ratio nu.
% WARNING: I don't believe this is accurate.  This procedure is never used.
    a = 1./K;
    b = -nu./K;
    c = 2*((1+nu)./K);
    
    if length(K)==1
        C = [ a b b 0 0 0;
              b a b 0 0 0;
              b b a 0 0 0;
              0 0 0 c 0 0;
              0 0 0 0 c 0;
              0 0 0 0 0 c ];
    else
        a = reshape(a,1,1,[]);
        b = reshape(b,1,1,[]);
        c = reshape(c,1,1,[]);
        z = zeros(size(c));
        C = [ 
                [ [ [a b b];[b a b];[b b a] ], zeros(3,3,length(K)) ];
                [ zeros(3,3,length(K)) [ [c z z];[z c z];[z z c] ] ]
            ];
    end
end
