function toks = split( pat, str )
%toks = split( pat, str )
%   Implementation of the Perl split() function.
%   Splits the string STR wherever the pattern PAT matches, and returns a
%   cell array of the strings between the matches.  If the string begins or
%   ends with a match, the cell array will correspondingly begin or end
%   with an empty string.

    if isempty(str)
        toks = {};
        return;
    end
    [ si, ei ] = regexp( str, pat, 'start', 'end' );
    si = [ (si-1), length(str) ];
    ei = [ 1 (ei+1) ];
    toks = cell(length(si),1);
    for i=1:length(si)
        toks{i} = str( ei(i):si(i) );
    end
end
