function v = interp( keys, vals, x )
%v = interp( keys, vals, x )
%   Look up x in keys (must be in ascending order) and return corresponding
%   value from vals, with piecewise linear interpolation.
    if x <= keys(1)
        v = vals(1);
        return
    end
    for i=2:length(keys)
        if x < keys(i)
            a = keys(i)-x;
            b = x - keys(i-1);
            v = (vals(i-1)*a + vals(i)*b)/(a+b);
            return;
        end
    end
    v = vals(length(keys));
end
