function h = makeStaticText( parent, position, initstring, varargin )
    h = uicontrol( ...
            'Parent', parent, ...
            'Style', 'text', ...
            'String', initstring, ...
            'HorizontalAlignment', 'left', ...
            'Visible', 'off', ...
            varargin{:}  );
    e = get( h, 'Extent' );
    p = get( h, 'Position' );
    set( h, 'Position', [p([1 2]), e([3 4])], 'Visible', 'on' );
    try
        color = get( parent, 'Color' );
    catch
        try
            color = get( parent, 'BackgroundColor' );
        catch
            color = [];
        end
    end
    if ~isempty(color)
        set( h, 'BackgroundColor', color );
    end
end
