function mesh = setradialfield(mesh,incr,whichGrowth,centre,power,add)
%MESH = SETRADIALFIELD(MESH,INCR,CENTRE)  Set growthfactor for all points.
    if nargin < 4, centre = [0, 0, 0]; end
    if nargin < 5, power = 1; end
    if nargin < 6, add = 0; end
    
    mesh = makeTRIvalid( mesh );
    newgrowth = zeros( size(mesh.nodes,1), 1 );

    for i=1:size(mesh.nodes,1)
        v = mesh.nodes(i,1:3) - centre;
        newgrowth(i) = ((v*v')^power)*incr;
    end
    ming = min( newgrowth );
    if ming < 0
        newgrowth = newgrowth - ming;
    end
    maxg = max( newgrowth );
    if maxg > 0
        newgrowth = newgrowth * abs(incr)/maxg;
    end
    if add
        mesh.morphogens(:,whichGrowth) = newgrowth + mesh.morphogens(:,whichGrowth);
    else
        mesh.morphogens(:,whichGrowth) = newgrowth;
    end
    mesh.saved = 0;
end


    
