function setInteractionModeFromGUI( handles )
    toolName = currentPanelName( handles );
%   fprintf( 1, 'setInteractionModeFromGUI %s\n', toolName );
    switch toolName
        case 'editor'
            mouseeditmodeMenu_Callback(handles.morpheditmodemenu, [], handles);
        case 'morphdist'
            if ~isempty(handles.mesh)
                morphEditMode = [ 'morph', ...
                    getMenuSelectedLabel( handles.morpheditmodemenu ) ];
                mgenIndex = getDisplayedMgenIndex( handles );
                handles.mesh = establishInteractionMode( handles.mesh, morphEditMode, ...
                    mgenIndex, ...
                    getDoubleFromDialog( handles.paintamount ) );
                c = sqrt(prod(handles.mesh.absKvector([1 2], mgenIndex)) );
                setDoubleInTextItem( handles.conductivityText, c );
                setDoubleInTextItem( handles.absorptionText, ...
                    handles.mesh.mgen_absorption(mgenIndex) );
            end
        case 'runsim'
            handles.mesh = establishInteractionMode( handles.mesh, 'showvalue' );
        case 'bio1'
            handles.mesh = establishInteractionMode( handles.mesh, '' );
            notifyPlotChange( handles );
        case 'bio2'
            handles.mesh = establishInteractionMode( handles.mesh, 'bioBedit' );
        otherwise
            handles.mesh = establishInteractionMode( handles.mesh, '' );
    end
    guidata( handles.output, handles );
end
