function setGUIMgenInfo( h, m )
%setGUIMgenInfo( h )
%   Cause the GUI to display values relating to a given morphogen.
%   If no mgenIndex is specified, get it from the displayedGrowthMenu item.
%   If there is no mesh, restore default values.

    if nargin < 2
        m = h.mesh;
    end
    [mgenIndex,mgenName] = getDisplayedMgen( h );
    if mgenIndex==0
        return;
    end
    if isempty( m )
        setDoubleInTextItem( h.conductivityText, 0 );
        setDoubleInTextItem( h.absorptionText, 0 );
        setSliderAndText( h.mutantslider, 1 );
        set( h.allowDilution, 'Value', false );
    else
        set( h.mgenColorChooser, 'BackgroundColor', m.mgenposcolors(:,mgenIndex)' );
        set( h.mgenNegColorChooser, 'BackgroundColor', m.mgennegcolors(:,mgenIndex)' );
        setMyLegend( m );
        c = sqrt(prod(m.absKvector([1 2], mgenIndex)) );
        setDoubleInTextItem( h.conductivityText, c );
        setDoubleInTextItem( h.absorptionText, m.mgen_absorption(mgenIndex) );
        setSliderAndText( h.mutantslider, m.mutantLevel(mgenIndex) );
        set( h.allowDilution, 'Value', m.mgen_dilution(mgenIndex) );
        interpButtons = get( h.splitMgenButtonGroup, 'Children' );
        if isempty( m )
            set( h.allowDilution, 'Value', false );
            interpType = 'mid';
        else
            set( h.allowDilution, 'Value', m.mgen_dilution(mgenIndex) );
            interpType = m.mgen_interpType{mgenIndex};
        end
        for i=1:length(interpButtons)
            if strcmp( get(interpButtons(i),'UserData'), interpType )
                set( interpButtons(i), 'Value', 1 );
            end
        end
    end
    if isempty(mgenName)
        set( h.morphdistpanel, 'Title', 'Morphogens' );
    else
        set( h.morphdistpanel, 'Title', ['Morphogen: ', mgenName] );
    end
    enableMutations( h );
end
