function mpc = mgenPerCell( m, mgenName, cellindexes )
% Calculate the average value of the given named morphogen over a given
% biological cell.
    if ~isfield( m.secondlayer, 'cells' )
        mpc = [];
        return;
    end
    if nargin < 3
        cellindexes = 1:length( m.secondlayer.cells );
    end
    mgenIndex = FindMorphogenIndex( m, mgenName );
    mpc = zeros( length(cellindexes), 1 );
    for ci=1:length(cellindexes)
        cellindex = cellindexes(ci);
        cvxs = m.secondlayer.cells(cellindex).vxs;
        meshvxs = m.tricellvxs( m.secondlayer.vxFEMcell(cvxs), : )';
        baryvxs = m.secondlayer.vxBaryCoords( cvxs, : );
        mgenvals = reshape( m.morphogens( meshvxs, mgenIndex ), 3, [] )';
        mgen_perCellVx = dot( mgenvals, baryvxs, 2 );
        mpc(ci) = mean(mgen_perCellVx);
    end
end

