function run_Callback(hObject, eventdata, handles)
    if isempty( handles.mesh )
        fprintf( 1, 'No mesh.\n' );
        return;
    end

    if get( handles.runFlag, 'Value' )
        % WARNING: Should ask user.
        beep;
        return;
    end

    setRunning( handles, 1 );
    clearFlag( handles, 'stopButton' );

    oldCursor = get(gcf,'Pointer');
    set(gcf,'Pointer','watch');

    [simsteps,ok1] = getIntFromDialog( handles.simsteps, 0 );
    handles.mesh.globalProps.maxIters = ...
        handles.mesh.globalProps.maxIters + simsteps;

    announceSimStatus( handles );

    handles.mesh = leaf_iterate( handles.mesh, ...
        simsteps, ...
        'plot', 1, ...
        'handles', handles );
    % leaf_iterate handles the recording of the command itself.
    
    setRunning( handles, 0 );
    guidata(hObject, handles);

    set(gcf,'Pointer',oldCursor);
end
