function m = polariseFELayer( m )
%m = polariseFELayer( m )
%   Create polarisation vectors for the FE layer.
%   Each vector is a unit vector in the plane of the cell.  The directions
%   are chosen randomly.

    m.FEpolarisation = zeros( size( m.tricellvxs ) );
    for ci=1:size( m.tricellvxs, 1 )
        m.FEpolarisation(ci,:) = randperp( m.unitcellnormals( ci, : ) );
    end
    m.FEpolfixed = false( size( m.tricellvxs, 1 ), 1 );
end
