function m = plotHighlightedEdges( m, eis )
    if ~isempty(eis)
        h = guidata( m.pictures(1) );
        theaxes = h.picture;
        he = m.edgeends( eis, : );
        if m.plotdefaults.thick
            he = he*2;
            if m.plotdefaults.decorateAside
                startnodecoords = m.prismnodes( he(:,1)-1, : );
                endnodecoords = m.prismnodes( he(:,2)-1, : );
            else
                startnodecoords = m.prismnodes( he(:,1), : );
                endnodecoords = m.prismnodes( he(:,2), : );
            end
        else
            startnodecoords = m.nodes( he(:,1), : );
            endnodecoords = m.nodes( he(:,2), : );
        end
        h = line( [ startnodecoords(:,1)'; endnodecoords(:,1)' ], ...
                  [ startnodecoords(:,2)'; endnodecoords(:,2)' ], ...
                  [ startnodecoords(:,3)'; endnodecoords(:,3)' ], ...
                  'Color', m.plotdefaults.seamlinecolor, ...
                  'LineWidth', m.plotdefaults.seamlinesize, 'Parent', theaxes );
        for i=1:length(eis)
            set( h(i), 'UserData', struct( 'edge', eis(i) ), ...
                       'ButtonDownFcn', {@doEdgeClick} );
        end
        m.plothandles.HLedgehandles(eis) = h;
    end
end
