function [p0f,p1f] = mixplotoptions( p0, p1, fraction )
% fraction is assumed not to be equal to 0 or 1, as these special cases
% will have been dealt with outside this function.
% For the interpolable plot options, set those fields in both p0f and p1f
% to the interpolation of their values from p0 and p1.
% For non-interpolable fields, set ths of p0f to their values on p0, and
% those of p1f to their values in p1.

    p0f = p0;
    lininterpFields = { ...
        'multibrighten', ...
        'monocolors', ...
        'canvascolor', ...
        'sparsedistance', ...
        'axisRange', ...
        'alpha', ...
        'ambientstrength', ...
        'layeroffset', ...
        'FEthicklinesize', ...
        'FEthinlinesize', ...
        'FElinecolor', ...
        'seamlinesize', ...
        'seamlinecolor', ...
        'bioAlinesize', ...
        'bioAlinecolor', ...
        'bioAnewlinecolor', ...
        'bioApointsize', ...
        'bioApointcolor', ...
        'bioAnewpointcolor', ...
        'bioAalpha', ...
        'axescolor', ...
        'nodenumbercolor', ...
        'edgenumbercolor', ...
        'FEnumbercolor', ...
        'bgcolor', ...
        'emptycolor', ...
        'clippingElevation', ...
        'clippingDistance', ...
        'clipmgenthreshold', ...
        'highlightthickness', ...
        'arrowthickness', ...
        'crossthickness', ...
        'arrowheadsize', ...
        'arrowheadratio', ...
        'highgradcolor', ...
        'lowgradcolor', ...
        'anisotropythreshold' ...
    };
    allinterpFields = { ...
        lininterpFields{:}, ...
        'ourViewParams', ...
        'matlabViewParams', ...
        'azimuth', ...
        'elevation', ...
        'roll' ...
    }; %#ok<CCAT>
    p0f = po_lininterp( p0f, p1, fraction, lininterpFields{:} );
    p0f.ourViewParams = interpolateOurViewParams( ...
        p0f.ourViewParams, p1.ourViewParams, fraction );
    p0f.matlabViewParams = cameraParamsFromOurViewParams( p0f.ourViewParams );
    p0f.azimuth = p0f.ourViewParams.azimuth;
    p0f.elevation = p0f.ourViewParams.elevation;
    p0f.roll = p0f.ourViewParams.roll;
    p1f = p1;
    p1f = setFromStructFields( p1f, p0f, allinterpFields{:} );
end

function ocp0 = interpolateOurViewParams( ocp0, ocp1, fraction )
    ocp0.azimuth = interpolateAngle( ocp0.azimuth, ocp1.azimuth, fraction );
    ocp0.roll = interpolateAngle( ocp0.roll, ocp1.roll, fraction );
    ocp0 = po_lininterp( ocp0, ocp1, fraction, ...
        'elevation', ...
        'fov', ...
        'pan', ...
        'targetdistance', ...
        'camdistance' );
end

function p0 = po_lininterp( p0, p1, fraction, varargin )
    for i=1:length(varargin)
        fn = varargin{i};
        if all(size( p0.(fn) ) == size( p1.(fn) ))
            v0 = p0.(fn);
            v1 = p1.(fn);
            if any( v0(:) ~= v1(:) )
                p0.(fn) = p0.(fn)*(1-fraction) + p1.(fn)*fraction;
            end
        end
    end
end
