function gt = makeMeshLocalGrowthTensor( m, ci )
%gt = makeMeshGrowthTensor( m, ci )
%   Calculate the growth tensors at the vertexes of the cell ci in the
%   local frame of ci.

    global gOLD_K_PAR gOLD_K_PER gOLD_BEND_PAR gOLD_BEND_PER gOLD_THICKNESS
    global gNEW_KA_PAR gNEW_KA_PER gNEW_KB_PAR gNEW_KB_PER
    global gNEW_K_NOR

    trivxs = m.tricellvxs(ci,:);
    if m.versioninfo.mgenversion==0
        if strcmp( m.globalProps.thicknessMode, 'scaled' )
            gthick = [];
        else
            gthick = m.morphogens( trivxs, gOLD_THICKNESS );
        end
        gt = makeLocalGrowthTensor( ...
                m.morphogens( trivxs, gOLD_K_PAR ), ...
                m.morphogens( trivxs, gOLD_K_PER ), ...
                m.morphogens( trivxs, gOLD_BEND_PAR ), ...
                m.morphogens( trivxs, gOLD_BEND_PER ), ...
                gthick, ...
                m.gradpolgrowth(ci,:) );
    else
        if strcmp( m.globalProps.thicknessMode, 'scaled' )
            gthick = [];
        else
            gthick = m.morphogens( trivxs, gNEW_K_NOR );
        end
        gt = makeLocalGrowthTensorNEW( ...
                m.morphogens( trivxs, gNEW_KA_PAR ), ...
                m.morphogens( trivxs, gNEW_KA_PER ), ...
                m.morphogens( trivxs, gNEW_KB_PAR ), ...
                m.morphogens( trivxs, gNEW_KB_PER ), ...
                gthick, ...
                m.gradpolgrowth(ci,:) );
    end
end
